/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters.relativedate;

import java.util.ArrayList;
import java.util.Objects;
import latitude.api.parameters.relativedate.RelativeDate;
import latitude.api.parameters.relativedate.RelativeDateDifference;
import latitude.api.parameters.relativedate.RelativeDateDifferenceDirection;
import latitude.api.parameters.relativedate.RelativeDateDifferenceUnit;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RelativeDateDifference", generator="Immutables")
@Immutable
public final class ImmutableRelativeDateDifference
implements RelativeDateDifference {
    private final String timezone;
    private final int count;
    private final RelativeDateDifferenceDirection direction;
    private final RelativeDateDifferenceUnit unit;

    private ImmutableRelativeDateDifference(String timezone, int count, RelativeDateDifferenceDirection direction, RelativeDateDifferenceUnit unit) {
        this.timezone = timezone;
        this.count = count;
        this.direction = direction;
        this.unit = unit;
    }

    @Override
    @JsonProperty(value="timezone")
    public String timezone() {
        return this.timezone;
    }

    @Override
    @JsonProperty(value="count")
    public int count() {
        return this.count;
    }

    @Override
    @JsonProperty(value="direction")
    public RelativeDateDifferenceDirection direction() {
        return this.direction;
    }

    @Override
    @JsonProperty(value="unit")
    public RelativeDateDifferenceUnit unit() {
        return this.unit;
    }

    public final ImmutableRelativeDateDifference withTimezone(String value) {
        String newValue = Objects.requireNonNull(value, "timezone");
        if (this.timezone.equals(newValue)) {
            return this;
        }
        return new ImmutableRelativeDateDifference(newValue, this.count, this.direction, this.unit);
    }

    public final ImmutableRelativeDateDifference withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableRelativeDateDifference(this.timezone, value, this.direction, this.unit);
    }

    public final ImmutableRelativeDateDifference withDirection(RelativeDateDifferenceDirection value) {
        RelativeDateDifferenceDirection newValue = Objects.requireNonNull(value, "direction");
        if (this.direction == newValue) {
            return this;
        }
        return new ImmutableRelativeDateDifference(this.timezone, this.count, newValue, this.unit);
    }

    public final ImmutableRelativeDateDifference withUnit(RelativeDateDifferenceUnit value) {
        RelativeDateDifferenceUnit newValue = Objects.requireNonNull(value, "unit");
        if (this.unit == newValue) {
            return this;
        }
        return new ImmutableRelativeDateDifference(this.timezone, this.count, this.direction, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelativeDateDifference && this.equalTo(0, (ImmutableRelativeDateDifference)another);
    }

    private boolean equalTo(int synthetic, ImmutableRelativeDateDifference another) {
        return this.timezone.equals(another.timezone) && this.count == another.count && this.direction.equals((Object)another.direction) && this.unit.equals((Object)another.unit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.timezone.hashCode();
        h += (h << 5) + this.count;
        h += (h << 5) + this.direction.hashCode();
        h += (h << 5) + this.unit.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("RelativeDateDifference").omitNullValues().add("timezone", this.timezone).add("count", this.count).add("direction", (Object)this.direction).add("unit", (Object)this.unit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRelativeDateDifference fromJson(Json json) {
        Builder builder = ImmutableRelativeDateDifference.builder();
        if (json.timezone != null) {
            builder.timezone(json.timezone);
        }
        if (json.countIsSet) {
            builder.count(json.count);
        }
        if (json.direction != null) {
            builder.direction(json.direction);
        }
        if (json.unit != null) {
            builder.unit(json.unit);
        }
        return builder.build();
    }

    public static ImmutableRelativeDateDifference copyOf(RelativeDateDifference instance) {
        if (instance instanceof ImmutableRelativeDateDifference) {
            return (ImmutableRelativeDateDifference)instance;
        }
        return ImmutableRelativeDateDifference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RelativeDateDifference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIMEZONE = 1L;
        private static final long INIT_BIT_COUNT = 2L;
        private static final long INIT_BIT_DIRECTION = 4L;
        private static final long INIT_BIT_UNIT = 8L;
        private long initBits = 15L;
        @Nullable
        private String timezone;
        private int count;
        @Nullable
        private RelativeDateDifferenceDirection direction;
        @Nullable
        private RelativeDateDifferenceUnit unit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RelativeDateDifference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RelativeDate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            RelativeDate instance;
            long bits = 0L;
            if (object instanceof RelativeDateDifference) {
                instance = (RelativeDateDifference)object;
                this.count(instance.count());
                this.unit(instance.unit());
                if ((bits & 1L) == 0L) {
                    this.timezone(instance.timezone());
                    bits |= 1L;
                }
                this.direction(instance.direction());
            }
            if (object instanceof RelativeDate) {
                instance = (RelativeDate)object;
                if ((bits & 1L) == 0L) {
                    this.timezone(instance.timezone());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="timezone")
        @CanIgnoreReturnValue
        public final Builder timezone(String timezone) {
            this.timezone = Objects.requireNonNull(timezone, "timezone");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="count")
        @CanIgnoreReturnValue
        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="direction")
        @CanIgnoreReturnValue
        public final Builder direction(RelativeDateDifferenceDirection direction) {
            this.direction = Objects.requireNonNull(direction, "direction");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="unit")
        @CanIgnoreReturnValue
        public final Builder unit(RelativeDateDifferenceUnit unit) {
            this.unit = Objects.requireNonNull(unit, "unit");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableRelativeDateDifference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelativeDateDifference(this.timezone, this.count, this.direction, this.unit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timezone");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("count");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("direction");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("unit");
            }
            return "Cannot build RelativeDateDifference, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RelativeDateDifference", generator="Immutables")
    static final class Json
    implements RelativeDateDifference {
        @Nullable
        String timezone;
        int count;
        boolean countIsSet;
        @Nullable
        RelativeDateDifferenceDirection direction;
        @Nullable
        RelativeDateDifferenceUnit unit;

        Json() {
        }

        @JsonProperty(value="timezone")
        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @JsonProperty(value="count")
        public void setCount(int count) {
            this.count = count;
            this.countIsSet = true;
        }

        @JsonProperty(value="direction")
        public void setDirection(RelativeDateDifferenceDirection direction) {
            this.direction = direction;
        }

        @JsonProperty(value="unit")
        public void setUnit(RelativeDateDifferenceUnit unit) {
            this.unit = unit;
        }

        @Override
        public String timezone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int count() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativeDateDifferenceDirection direction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativeDateDifferenceUnit unit() {
            throw new UnsupportedOperationException();
        }
    }
}

