/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.parameters.relativedate;

import java.util.ArrayList;
import java.util.Objects;
import latitude.api.parameters.relativedate.RelativeDate;
import latitude.api.parameters.relativedate.RelativeDateFirstOf;
import latitude.api.parameters.relativedate.RelativeDateFirstOfAdjective;
import latitude.api.parameters.relativedate.RelativeDateFirstOfUnit;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RelativeDateFirstOf", generator="Immutables")
@Immutable
public final class ImmutableRelativeDateFirstOf
implements RelativeDateFirstOf {
    private final String timezone;
    private final RelativeDateFirstOfAdjective adjective;
    private final RelativeDateFirstOfUnit unit;

    private ImmutableRelativeDateFirstOf(String timezone, RelativeDateFirstOfAdjective adjective, RelativeDateFirstOfUnit unit) {
        this.timezone = timezone;
        this.adjective = adjective;
        this.unit = unit;
    }

    @Override
    @JsonProperty(value="timezone")
    public String timezone() {
        return this.timezone;
    }

    @Override
    @JsonProperty(value="adjective")
    public RelativeDateFirstOfAdjective adjective() {
        return this.adjective;
    }

    @Override
    @JsonProperty(value="unit")
    public RelativeDateFirstOfUnit unit() {
        return this.unit;
    }

    public final ImmutableRelativeDateFirstOf withTimezone(String value) {
        String newValue = Objects.requireNonNull(value, "timezone");
        if (this.timezone.equals(newValue)) {
            return this;
        }
        return new ImmutableRelativeDateFirstOf(newValue, this.adjective, this.unit);
    }

    public final ImmutableRelativeDateFirstOf withAdjective(RelativeDateFirstOfAdjective value) {
        RelativeDateFirstOfAdjective newValue = Objects.requireNonNull(value, "adjective");
        if (this.adjective == newValue) {
            return this;
        }
        return new ImmutableRelativeDateFirstOf(this.timezone, newValue, this.unit);
    }

    public final ImmutableRelativeDateFirstOf withUnit(RelativeDateFirstOfUnit value) {
        RelativeDateFirstOfUnit newValue = Objects.requireNonNull(value, "unit");
        if (this.unit == newValue) {
            return this;
        }
        return new ImmutableRelativeDateFirstOf(this.timezone, this.adjective, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelativeDateFirstOf && this.equalTo(0, (ImmutableRelativeDateFirstOf)another);
    }

    private boolean equalTo(int synthetic, ImmutableRelativeDateFirstOf another) {
        return this.timezone.equals(another.timezone) && this.adjective.equals((Object)another.adjective) && this.unit.equals((Object)another.unit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.timezone.hashCode();
        h += (h << 5) + this.adjective.hashCode();
        h += (h << 5) + this.unit.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("RelativeDateFirstOf").omitNullValues().add("timezone", this.timezone).add("adjective", (Object)this.adjective).add("unit", (Object)this.unit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRelativeDateFirstOf fromJson(Json json) {
        Builder builder = ImmutableRelativeDateFirstOf.builder();
        if (json.timezone != null) {
            builder.timezone(json.timezone);
        }
        if (json.adjective != null) {
            builder.adjective(json.adjective);
        }
        if (json.unit != null) {
            builder.unit(json.unit);
        }
        return builder.build();
    }

    public static ImmutableRelativeDateFirstOf copyOf(RelativeDateFirstOf instance) {
        if (instance instanceof ImmutableRelativeDateFirstOf) {
            return (ImmutableRelativeDateFirstOf)instance;
        }
        return ImmutableRelativeDateFirstOf.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RelativeDateFirstOf", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIMEZONE = 1L;
        private static final long INIT_BIT_ADJECTIVE = 2L;
        private static final long INIT_BIT_UNIT = 4L;
        private long initBits = 7L;
        @Nullable
        private String timezone;
        @Nullable
        private RelativeDateFirstOfAdjective adjective;
        @Nullable
        private RelativeDateFirstOfUnit unit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RelativeDate instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RelativeDateFirstOf instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            RelativeDate instance;
            long bits = 0L;
            if (object instanceof RelativeDate) {
                instance = (RelativeDate)object;
                if ((bits & 1L) == 0L) {
                    this.timezone(instance.timezone());
                    bits |= 1L;
                }
            }
            if (object instanceof RelativeDateFirstOf) {
                instance = (RelativeDateFirstOf)object;
                if ((bits & 1L) == 0L) {
                    this.timezone(instance.timezone());
                    bits |= 1L;
                }
                this.adjective(instance.adjective());
                this.unit(instance.unit());
            }
        }

        @JsonProperty(value="timezone")
        @CanIgnoreReturnValue
        public final Builder timezone(String timezone) {
            this.timezone = Objects.requireNonNull(timezone, "timezone");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="adjective")
        @CanIgnoreReturnValue
        public final Builder adjective(RelativeDateFirstOfAdjective adjective) {
            this.adjective = Objects.requireNonNull(adjective, "adjective");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="unit")
        @CanIgnoreReturnValue
        public final Builder unit(RelativeDateFirstOfUnit unit) {
            this.unit = Objects.requireNonNull(unit, "unit");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRelativeDateFirstOf build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelativeDateFirstOf(this.timezone, this.adjective, this.unit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timezone");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("adjective");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("unit");
            }
            return "Cannot build RelativeDateFirstOf, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RelativeDateFirstOf", generator="Immutables")
    static final class Json
    implements RelativeDateFirstOf {
        @Nullable
        String timezone;
        @Nullable
        RelativeDateFirstOfAdjective adjective;
        @Nullable
        RelativeDateFirstOfUnit unit;

        Json() {
        }

        @JsonProperty(value="timezone")
        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @JsonProperty(value="adjective")
        public void setAdjective(RelativeDateFirstOfAdjective adjective) {
            this.adjective = adjective;
        }

        @JsonProperty(value="unit")
        public void setUnit(RelativeDateFirstOfUnit unit) {
            this.unit = unit;
        }

        @Override
        public String timezone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativeDateFirstOfAdjective adjective() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelativeDateFirstOfUnit unit() {
            throw new UnsupportedOperationException();
        }
    }
}

