/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.path;

import java.util.UUID;
import latitude.api.path.ImmutableDatasetRid;
import latitude.api.path.RidWrapper;
import latitude.api.path.RidWrapperDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonSerialize(as=ImmutableDatasetRid.class)
@JsonDeserialize(using=DatasetRidDeserializer.class)
@Value.Immutable
public abstract class DatasetRid
extends RidWrapper {
    static final String FOUNDRY_SERVICE = "foundry";
    static final String DATASET_TYPE = "dataset";

    @Override
    @Value.Parameter
    public abstract ResourceIdentifier getRid();

    @JsonCreator
    public static DatasetRid fromString(String rid) {
        return DatasetRid.of(ResourceIdentifier.of(rid));
    }

    public static DatasetRid createRandom(String instance) {
        return DatasetRid.of(ResourceIdentifier.of(FOUNDRY_SERVICE, instance, DATASET_TYPE, UUID.randomUUID().toString()));
    }

    public static DatasetRid of(ResourceIdentifier rid) {
        return ImmutableDatasetRid.of(rid);
    }

    @Value.Check
    protected void validate() {
        this.validateRid(FOUNDRY_SERVICE, DATASET_TYPE);
    }

    static final class DatasetRidDeserializer
    extends RidWrapperDeserializer<DatasetRid> {
        DatasetRidDeserializer() {
            super(DatasetRid::fromString);
        }
    }
}

