/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.path;

import java.util.UUID;
import latitude.api.path.ImmutableRefRid;
import latitude.api.path.RidWrapper;
import latitude.api.path.RidWrapperDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonSerialize(as=ImmutableRefRid.class)
@JsonDeserialize(using=RefRidDeserializer.class)
@Value.Immutable
public abstract class RefRid
extends RidWrapper
implements Comparable<RefRid> {
    static final String SERVICE = "contour";
    public static final String TYPE = "ref";

    @Override
    @Value.Parameter
    public abstract ResourceIdentifier getRid();

    @JsonCreator
    public static RefRid fromString(String rid) {
        return RefRid.of(ResourceIdentifier.of(rid));
    }

    public static RefRid valueOf(String refId) {
        return RefRid.fromString(refId);
    }

    public static RefRid createRandom(String instance) {
        return RefRid.of(instance, UUID.randomUUID().toString());
    }

    public static RefRid of(String instance, String locator) {
        return RefRid.of(ResourceIdentifier.of(SERVICE, instance, TYPE, locator));
    }

    public static RefRid of(ResourceIdentifier rid) {
        return ImmutableRefRid.of(rid);
    }

    @Value.Check
    protected void validate() {
        this.validateService(SERVICE);
        this.validateType(TYPE);
    }

    @Override
    public int compareTo(RefRid other) {
        return this.getRid().toString().compareTo(other.getRid().toString());
    }

    static final class RefRidDeserializer
    extends RidWrapperDeserializer<RefRid> {
        RefRidDeserializer() {
            super(RefRid::fromString);
        }
    }
}

