/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.path;

import java.util.UUID;
import latitude.api.path.ImmutableRestrictedViewRid;
import latitude.api.path.RidWrapper;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.org.immutables.value.Value;

@Value.Immutable(builder=false)
public abstract class RestrictedViewRid
extends RidWrapper {
    private static final String GPS_SERVICE = "gps";
    private static final String VIEW_TYPE = "view";
    public static final RestrictedViewRid REDACTED = RestrictedViewRid.create("redacted", "redacted");

    @Override
    @JsonValue
    @Value.Parameter
    public abstract ResourceIdentifier getRid();

    @JsonCreator
    public static RestrictedViewRid fromString(String rid) {
        return RestrictedViewRid.of(ResourceIdentifier.of(rid));
    }

    public static RestrictedViewRid valueOf(String rid) {
        return RestrictedViewRid.fromString(rid);
    }

    public static RestrictedViewRid of(ResourceIdentifier rid) {
        return ImmutableRestrictedViewRid.of(rid);
    }

    public static RestrictedViewRid createRandom(String instance) {
        return RestrictedViewRid.create(instance, UUID.randomUUID().toString());
    }

    private static RestrictedViewRid create(String instance, String locator) {
        return RestrictedViewRid.of(ResourceIdentifier.of(GPS_SERVICE, instance, VIEW_TYPE, locator));
    }

    @Value.Check
    protected void validate() {
        this.validateRid(GPS_SERVICE, VIEW_TYPE);
    }

    public shadow.palantir.driver.com.palantir.gps.api.view.RestrictedViewRid toNative() {
        return shadow.palantir.driver.com.palantir.gps.api.view.RestrictedViewRid.of(this.getRid());
    }
}

