/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.path;

import java.util.UUID;
import latitude.api.path.ImmutableRestrictedViewTransactionRid;
import latitude.api.path.RidWrapper;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.org.immutables.value.Value;

@Value.Immutable(builder=false)
public abstract class RestrictedViewTransactionRid
extends RidWrapper {
    private static final String GPS_SERVICE = "gps";
    private static final String VIEW_TRANSACTION_TYPE = "viewtransaction";
    public static final RestrictedViewTransactionRid REDACTED = RestrictedViewTransactionRid.create("redacted", "redacted");

    @Override
    @JsonValue
    @Value.Parameter
    public abstract ResourceIdentifier getRid();

    @JsonCreator
    public static RestrictedViewTransactionRid fromString(String rid) {
        return RestrictedViewTransactionRid.of(ResourceIdentifier.of(rid));
    }

    public static RestrictedViewTransactionRid of(ResourceIdentifier rid) {
        return ImmutableRestrictedViewTransactionRid.of(rid);
    }

    public static RestrictedViewTransactionRid createRandom(String instance) {
        return RestrictedViewTransactionRid.create(instance, UUID.randomUUID().toString());
    }

    private static RestrictedViewTransactionRid create(String instance, String locator) {
        return RestrictedViewTransactionRid.of(ResourceIdentifier.of(GPS_SERVICE, instance, VIEW_TRANSACTION_TYPE, locator));
    }

    @Value.Check
    protected void validate() {
        this.validateRid(GPS_SERVICE, VIEW_TRANSACTION_TYPE);
    }

    public shadow.palantir.driver.com.palantir.gps.api.view.RestrictedViewTransactionRid toNative() {
        return shadow.palantir.driver.com.palantir.gps.api.view.RestrictedViewTransactionRid.of(this.getRid());
    }
}

