/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.path;

import com.palantir.logsafe.SafeArg;
import java.util.regex.Pattern;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.org.immutables.value.Value;

public abstract class RidWrapper {
    @Value.Parameter
    public abstract ResourceIdentifier getRid();

    @JsonIgnore
    public ResourceIdentifier get() {
        return this.getRid();
    }

    public final String toString() {
        return this.getRid().toString();
    }

    protected void validateRid(String expectedService, String expectedType) {
        this.validateService(expectedService);
        this.validateType(expectedType);
    }

    void validateType(String expectedType) {
        ContourExceptions.server500Precondition(Pattern.matches(expectedType, this.getRid().getType()), "Expecting an rid with a different type.", SafeArg.of("expectedRidType", expectedType), SafeArg.of("actualRidType", this.getRid().getType()));
    }

    protected void validateService(String expectedService) {
        ContourExceptions.server500Precondition(Pattern.matches(expectedService, this.getRid().getService()), "Expecting an rid with a different service.", SafeArg.of("expectedRidService", expectedService), SafeArg.of("actualRidService", this.getRid().getService()));
    }

    protected void validateLocator(String expectedLocator) {
        ContourExceptions.server500Precondition(Pattern.matches(expectedLocator, this.getRid().getLocator()), "Expecting an rid with a different locator.", SafeArg.of("expectedRidLocator", expectedLocator), SafeArg.of("actualRidLocator", this.getRid().getLocator()));
    }
}

