/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.path;

import java.io.IOException;
import java.util.function.Function;
import latitude.api.exception.ContourExceptions;
import latitude.api.jackson.ContourJackson;
import latitude.api.path.ImmutableRidHolder;
import latitude.api.path.RidWrapper;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import shadow.palantir.driver.org.immutables.value.Value;

public abstract class RidWrapperDeserializer<T extends RidWrapper>
extends JsonDeserializer<T> {
    private final Function<String, T> fromString;

    protected RidWrapperDeserializer(Function<String, T> fromString) {
        this.fromString = fromString;
    }

    @Override
    public final T deserialize(JsonParser parser, DeserializationContext _context) throws IOException {
        String ridString;
        switch (parser.getCurrentToken()) {
            case VALUE_STRING: {
                ridString = parser.getValueAsString();
                break;
            }
            case START_OBJECT: {
                ridString = ContourJackson.OBJECT_MAPPER.reader().readValue(parser, RidHolder.class).getRid().toString();
                break;
            }
            default: {
                throw ContourExceptions.server500IllegalEnum(parser.getCurrentToken());
            }
        }
        return (T)((RidWrapper)this.fromString.apply(ridString));
    }

    @Override
    public T deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer _typeDeserializer) throws IOException {
        return (T)this.deserialize(parser, context);
    }

    @JsonDeserialize(as=ImmutableRidHolder.class)
    @Value.Immutable
    static abstract class RidHolder
    extends RidWrapper {
        RidHolder() {
        }
    }
}

