/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.path;

import java.util.UUID;
import latitude.api.path.ImmutableTableRid;
import latitude.api.path.RidWrapper;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.org.immutables.value.Value;

@Value.Immutable(builder=false)
public abstract class TableRid
extends RidWrapper {
    private static final String TABLES_SERVICE = "tables";
    private static final String TABLE_TYPE = "table";
    public static final TableRid REDACTED = TableRid.create("redacted", "redacted");

    @Override
    @JsonValue
    @Value.Parameter
    public abstract ResourceIdentifier getRid();

    @JsonCreator
    public static TableRid fromString(String rid) {
        return TableRid.of(ResourceIdentifier.of(rid));
    }

    public static TableRid valueOf(String rid) {
        return TableRid.fromString(rid);
    }

    public static TableRid of(ResourceIdentifier rid) {
        return ImmutableTableRid.of(rid);
    }

    public static TableRid createRandom(String instance) {
        return TableRid.create(instance, UUID.randomUUID().toString());
    }

    private static TableRid create(String instance, String locator) {
        return TableRid.of(ResourceIdentifier.of(TABLES_SERVICE, instance, TABLE_TYPE, locator));
    }

    @Value.Check
    protected void validate() {
        this.validateRid(TABLES_SERVICE, TABLE_TYPE);
    }

    public shadow.palantir.driver.com.palantir.tables.api.TableRid toNative() {
        return shadow.palantir.driver.com.palantir.tables.api.TableRid.of(this.getRid());
    }
}

