/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.query;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import latitude.api.metrics.SourceMetadata;
import latitude.api.path.DatasetRid;
import latitude.api.query.LatitudeQueryDescription;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.common.collect.ImmutableSet;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LatitudeQueryDescription", generator="Immutables")
@Immutable
public final class ImmutableLatitudeQueryDescription
extends LatitudeQueryDescription {
    @Nullable
    private final String humanReadableDescription;
    private final ImmutableMap<String, String> metadata;
    @Nullable
    private final SourceMetadata sourceMetadata;
    private final ImmutableSet<DatasetRid> trimmedDatasetRids;
    @Nullable
    private final String requestTraceId;
    @Nullable
    private final Long requestTimeMillis;

    private ImmutableLatitudeQueryDescription(@Nullable String humanReadableDescription, ImmutableMap<String, String> metadata, @Nullable SourceMetadata sourceMetadata, ImmutableSet<DatasetRid> trimmedDatasetRids, @Nullable String requestTraceId, @Nullable Long requestTimeMillis) {
        this.humanReadableDescription = humanReadableDescription;
        this.metadata = metadata;
        this.sourceMetadata = sourceMetadata;
        this.trimmedDatasetRids = trimmedDatasetRids;
        this.requestTraceId = requestTraceId;
        this.requestTimeMillis = requestTimeMillis;
    }

    @Override
    @JsonProperty(value="humanReadableDescription")
    public Optional<String> humanReadableDescription() {
        return Optional.ofNullable(this.humanReadableDescription);
    }

    @JsonProperty(value="metadata")
    public ImmutableMap<String, String> metadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="sourceMetadata")
    public Optional<SourceMetadata> sourceMetadata() {
        return Optional.ofNullable(this.sourceMetadata);
    }

    @JsonProperty(value="trimmedDatasetRids")
    public ImmutableSet<DatasetRid> trimmedDatasetRids() {
        return this.trimmedDatasetRids;
    }

    @Override
    @JsonProperty(value="requestTraceId")
    public Optional<String> requestTraceId() {
        return Optional.ofNullable(this.requestTraceId);
    }

    @Override
    @JsonProperty(value="requestTimeMillis")
    public Optional<Long> requestTimeMillis() {
        return Optional.ofNullable(this.requestTimeMillis);
    }

    public final ImmutableLatitudeQueryDescription withHumanReadableDescription(String value) {
        String newValue = Objects.requireNonNull(value, "humanReadableDescription");
        if (Objects.equals(this.humanReadableDescription, newValue)) {
            return this;
        }
        return new ImmutableLatitudeQueryDescription(newValue, this.metadata, this.sourceMetadata, this.trimmedDatasetRids, this.requestTraceId, this.requestTimeMillis);
    }

    public final ImmutableLatitudeQueryDescription withHumanReadableDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.humanReadableDescription, value)) {
            return this;
        }
        return new ImmutableLatitudeQueryDescription(value, this.metadata, this.sourceMetadata, this.trimmedDatasetRids, this.requestTraceId, this.requestTimeMillis);
    }

    public final ImmutableLatitudeQueryDescription withMetadata(Map<String, ? extends String> entries) {
        if (this.metadata == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableLatitudeQueryDescription(this.humanReadableDescription, newValue, this.sourceMetadata, this.trimmedDatasetRids, this.requestTraceId, this.requestTimeMillis);
    }

    public final ImmutableLatitudeQueryDescription withSourceMetadata(SourceMetadata value) {
        SourceMetadata newValue = Objects.requireNonNull(value, "sourceMetadata");
        if (this.sourceMetadata == newValue) {
            return this;
        }
        return new ImmutableLatitudeQueryDescription(this.humanReadableDescription, this.metadata, newValue, this.trimmedDatasetRids, this.requestTraceId, this.requestTimeMillis);
    }

    public final ImmutableLatitudeQueryDescription withSourceMetadata(Optional<? extends SourceMetadata> optional) {
        SourceMetadata value = optional.orElse(null);
        if (this.sourceMetadata == value) {
            return this;
        }
        return new ImmutableLatitudeQueryDescription(this.humanReadableDescription, this.metadata, value, this.trimmedDatasetRids, this.requestTraceId, this.requestTimeMillis);
    }

    public final ImmutableLatitudeQueryDescription withTrimmedDatasetRids(DatasetRid ... elements) {
        ImmutableSet<DatasetRid> newValue = ImmutableSet.copyOf(elements);
        return new ImmutableLatitudeQueryDescription(this.humanReadableDescription, this.metadata, this.sourceMetadata, newValue, this.requestTraceId, this.requestTimeMillis);
    }

    public final ImmutableLatitudeQueryDescription withTrimmedDatasetRids(Iterable<? extends DatasetRid> elements) {
        if (this.trimmedDatasetRids == elements) {
            return this;
        }
        ImmutableSet<DatasetRid> newValue = ImmutableSet.copyOf(elements);
        return new ImmutableLatitudeQueryDescription(this.humanReadableDescription, this.metadata, this.sourceMetadata, newValue, this.requestTraceId, this.requestTimeMillis);
    }

    public final ImmutableLatitudeQueryDescription withRequestTraceId(String value) {
        String newValue = Objects.requireNonNull(value, "requestTraceId");
        if (Objects.equals(this.requestTraceId, newValue)) {
            return this;
        }
        return new ImmutableLatitudeQueryDescription(this.humanReadableDescription, this.metadata, this.sourceMetadata, this.trimmedDatasetRids, newValue, this.requestTimeMillis);
    }

    public final ImmutableLatitudeQueryDescription withRequestTraceId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.requestTraceId, value)) {
            return this;
        }
        return new ImmutableLatitudeQueryDescription(this.humanReadableDescription, this.metadata, this.sourceMetadata, this.trimmedDatasetRids, value, this.requestTimeMillis);
    }

    public final ImmutableLatitudeQueryDescription withRequestTimeMillis(long value) {
        Long newValue = value;
        if (Objects.equals(this.requestTimeMillis, newValue)) {
            return this;
        }
        return new ImmutableLatitudeQueryDescription(this.humanReadableDescription, this.metadata, this.sourceMetadata, this.trimmedDatasetRids, this.requestTraceId, newValue);
    }

    public final ImmutableLatitudeQueryDescription withRequestTimeMillis(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.requestTimeMillis, value)) {
            return this;
        }
        return new ImmutableLatitudeQueryDescription(this.humanReadableDescription, this.metadata, this.sourceMetadata, this.trimmedDatasetRids, this.requestTraceId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLatitudeQueryDescription && this.equalTo(0, (ImmutableLatitudeQueryDescription)another);
    }

    private boolean equalTo(int synthetic, ImmutableLatitudeQueryDescription another) {
        return Objects.equals(this.humanReadableDescription, another.humanReadableDescription) && this.metadata.equals(another.metadata) && Objects.equals(this.sourceMetadata, another.sourceMetadata) && this.trimmedDatasetRids.equals(another.trimmedDatasetRids) && Objects.equals(this.requestTraceId, another.requestTraceId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.humanReadableDescription);
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceMetadata);
        h += (h << 5) + this.trimmedDatasetRids.hashCode();
        h += (h << 5) + Objects.hashCode(this.requestTraceId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("LatitudeQueryDescription").omitNullValues().add("humanReadableDescription", this.humanReadableDescription).add("metadata", this.metadata).add("sourceMetadata", this.sourceMetadata).add("trimmedDatasetRids", this.trimmedDatasetRids).add("requestTraceId", this.requestTraceId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLatitudeQueryDescription fromJson(Json json) {
        LatitudeQueryDescription.Builder builder = new LatitudeQueryDescription.Builder();
        if (json.humanReadableDescription != null) {
            builder.humanReadableDescription(json.humanReadableDescription);
        }
        if (json.metadata != null) {
            builder.putAllMetadata(json.metadata);
        }
        if (json.sourceMetadata != null) {
            builder.sourceMetadata(json.sourceMetadata);
        }
        if (json.trimmedDatasetRids != null) {
            builder.addAllTrimmedDatasetRids(json.trimmedDatasetRids);
        }
        if (json.requestTraceId != null) {
            builder.requestTraceId(json.requestTraceId);
        }
        if (json.requestTimeMillis != null) {
            builder.requestTimeMillis(json.requestTimeMillis);
        }
        return builder.build();
    }

    public static ImmutableLatitudeQueryDescription copyOf(LatitudeQueryDescription instance) {
        if (instance instanceof ImmutableLatitudeQueryDescription) {
            return (ImmutableLatitudeQueryDescription)instance;
        }
        return new LatitudeQueryDescription.Builder().from(instance).build();
    }

    @Generated(from="LatitudeQueryDescription", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        @Nullable
        private String humanReadableDescription;
        private ImmutableMap.Builder<String, String> metadata = ImmutableMap.builder();
        @Nullable
        private SourceMetadata sourceMetadata;
        private ImmutableSet.Builder<DatasetRid> trimmedDatasetRids = ImmutableSet.builder();
        @Nullable
        private String requestTraceId;
        @Nullable
        private Long requestTimeMillis;

        public Builder() {
            if (!(this instanceof LatitudeQueryDescription.Builder)) {
                throw new UnsupportedOperationException("Use: new LatitudeQueryDescription.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder from(LatitudeQueryDescription instance) {
            Optional<Long> requestTimeMillisOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> humanReadableDescriptionOptional = instance.humanReadableDescription();
            if (humanReadableDescriptionOptional.isPresent()) {
                this.humanReadableDescription(humanReadableDescriptionOptional);
            }
            this.putAllMetadata(instance.metadata());
            Optional<SourceMetadata> sourceMetadataOptional = instance.sourceMetadata();
            if (sourceMetadataOptional.isPresent()) {
                this.sourceMetadata(sourceMetadataOptional);
            }
            this.addAllTrimmedDatasetRids(instance.trimmedDatasetRids());
            Optional<String> requestTraceIdOptional = instance.requestTraceId();
            if (requestTraceIdOptional.isPresent()) {
                this.requestTraceId(requestTraceIdOptional);
            }
            if ((requestTimeMillisOptional = instance.requestTimeMillis()).isPresent()) {
                this.requestTimeMillis(requestTimeMillisOptional);
            }
            return (LatitudeQueryDescription.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder humanReadableDescription(String humanReadableDescription) {
            this.humanReadableDescription = Objects.requireNonNull(humanReadableDescription, "humanReadableDescription");
            return (LatitudeQueryDescription.Builder)this;
        }

        @JsonProperty(value="humanReadableDescription")
        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder humanReadableDescription(Optional<String> humanReadableDescription) {
            this.humanReadableDescription = humanReadableDescription.orElse(null);
            return (LatitudeQueryDescription.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder putMetadata(String key, String value) {
            this.metadata.put(key, value);
            return (LatitudeQueryDescription.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder putMetadata(Map.Entry<String, ? extends String> entry) {
            this.metadata.put(entry);
            return (LatitudeQueryDescription.Builder)this;
        }

        @JsonProperty(value="metadata")
        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder metadata(Map<String, ? extends String> entries) {
            this.metadata = ImmutableMap.builder();
            return this.putAllMetadata(entries);
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder putAllMetadata(Map<String, ? extends String> entries) {
            this.metadata.putAll(entries);
            return (LatitudeQueryDescription.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder sourceMetadata(SourceMetadata sourceMetadata) {
            this.sourceMetadata = Objects.requireNonNull(sourceMetadata, "sourceMetadata");
            return (LatitudeQueryDescription.Builder)this;
        }

        @JsonProperty(value="sourceMetadata")
        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder sourceMetadata(Optional<? extends SourceMetadata> sourceMetadata) {
            this.sourceMetadata = sourceMetadata.orElse(null);
            return (LatitudeQueryDescription.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder addTrimmedDatasetRids(DatasetRid element) {
            this.trimmedDatasetRids.add((Object)element);
            return (LatitudeQueryDescription.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder addTrimmedDatasetRids(DatasetRid ... elements) {
            this.trimmedDatasetRids.add(elements);
            return (LatitudeQueryDescription.Builder)this;
        }

        @JsonProperty(value="trimmedDatasetRids")
        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder trimmedDatasetRids(Iterable<? extends DatasetRid> elements) {
            this.trimmedDatasetRids = ImmutableSet.builder();
            return this.addAllTrimmedDatasetRids(elements);
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder addAllTrimmedDatasetRids(Iterable<? extends DatasetRid> elements) {
            this.trimmedDatasetRids.addAll(elements);
            return (LatitudeQueryDescription.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder requestTraceId(String requestTraceId) {
            this.requestTraceId = Objects.requireNonNull(requestTraceId, "requestTraceId");
            return (LatitudeQueryDescription.Builder)this;
        }

        @JsonProperty(value="requestTraceId")
        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder requestTraceId(Optional<String> requestTraceId) {
            this.requestTraceId = requestTraceId.orElse(null);
            return (LatitudeQueryDescription.Builder)this;
        }

        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder requestTimeMillis(long requestTimeMillis) {
            this.requestTimeMillis = requestTimeMillis;
            return (LatitudeQueryDescription.Builder)this;
        }

        @JsonProperty(value="requestTimeMillis")
        @CanIgnoreReturnValue
        public final LatitudeQueryDescription.Builder requestTimeMillis(Optional<Long> requestTimeMillis) {
            this.requestTimeMillis = requestTimeMillis.orElse(null);
            return (LatitudeQueryDescription.Builder)this;
        }

        public ImmutableLatitudeQueryDescription build() {
            return new ImmutableLatitudeQueryDescription(this.humanReadableDescription, this.metadata.build(), this.sourceMetadata, (ImmutableSet<DatasetRid>)this.trimmedDatasetRids.build(), this.requestTraceId, this.requestTimeMillis);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LatitudeQueryDescription", generator="Immutables")
    static final class Json
    extends LatitudeQueryDescription {
        @Nullable
        Optional<String> humanReadableDescription = Optional.empty();
        @Nullable
        Map<String, String> metadata = ImmutableMap.of();
        @Nullable
        Optional<SourceMetadata> sourceMetadata = Optional.empty();
        @Nullable
        Set<DatasetRid> trimmedDatasetRids = ImmutableSet.of();
        @Nullable
        Optional<String> requestTraceId = Optional.empty();
        @Nullable
        Optional<Long> requestTimeMillis = Optional.empty();

        Json() {
        }

        @JsonProperty(value="humanReadableDescription")
        public void setHumanReadableDescription(Optional<String> humanReadableDescription) {
            this.humanReadableDescription = humanReadableDescription;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="sourceMetadata")
        public void setSourceMetadata(Optional<SourceMetadata> sourceMetadata) {
            this.sourceMetadata = sourceMetadata;
        }

        @JsonProperty(value="trimmedDatasetRids")
        public void setTrimmedDatasetRids(Set<DatasetRid> trimmedDatasetRids) {
            this.trimmedDatasetRids = trimmedDatasetRids;
        }

        @JsonProperty(value="requestTraceId")
        public void setRequestTraceId(Optional<String> requestTraceId) {
            this.requestTraceId = requestTraceId;
        }

        @JsonProperty(value="requestTimeMillis")
        public void setRequestTimeMillis(Optional<Long> requestTimeMillis) {
            this.requestTimeMillis = requestTimeMillis;
        }

        @Override
        public Optional<String> humanReadableDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> metadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SourceMetadata> sourceMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<DatasetRid> trimmedDatasetRids() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> requestTraceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> requestTimeMillis() {
            throw new UnsupportedOperationException();
        }
    }
}

