/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.query;

import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import latitude.api.metrics.SourceMetadata;
import latitude.api.path.DatasetRid;
import latitude.api.query.ImmutableLatitudeQueryDescription;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.one.util.streamex.EntryStream;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableLatitudeQueryDescription.class)
@JsonSerialize(as=ImmutableLatitudeQueryDescription.class)
@Value.Immutable
public abstract class LatitudeQueryDescription {
    private static final SafeLogger log = SafeLoggerFactory.get(LatitudeQueryDescription.class);
    private static final String SKIP_NON_CONTOUR_BACKEND_CACHE_KEY = "Skip the non-contour backend cache";

    public final boolean skipBackendCache() {
        return Boolean.parseBoolean(this.metadata().get(SKIP_NON_CONTOUR_BACKEND_CACHE_KEY));
    }

    public abstract Optional<String> humanReadableDescription();

    public abstract Map<String, String> metadata();

    public abstract Optional<SourceMetadata> sourceMetadata();

    public abstract Set<DatasetRid> trimmedDatasetRids();

    public abstract Optional<String> requestTraceId();

    @Value.Auxiliary
    public abstract Optional<Long> requestTimeMillis();

    public LatitudeQueryDescription withBackendCacheDisabled() {
        Map<String, String> existingMetadataWithoutBackendCache = EntryStream.of(this.metadata()).removeKeys(SKIP_NON_CONTOUR_BACKEND_CACHE_KEY::equals).toMap();
        return LatitudeQueryDescription.builder().from(this).metadata(existingMetadataWithoutBackendCache).skipBackendCache(true).build();
    }

    public static Builder builder() {
        return new Builder().withCurrentTraceId().requestTimeMillis(System.currentTimeMillis());
    }

    public static final class Builder
    extends ImmutableLatitudeQueryDescription.Builder {
        public Builder skipBackendCache(boolean skipBackendCache) {
            this.putMetadata(LatitudeQueryDescription.SKIP_NON_CONTOUR_BACKEND_CACHE_KEY, Boolean.toString(skipBackendCache));
            return this;
        }

        public Builder addSourceMetadata(SourceMetadata sm) {
            this.putMetadata("UserId", sm.userId().userId());
            this.putMetadata("GraphId", sm.graphId().orElse(""));
            this.putMetadata("NodeId", sm.nodeId().orElse(""));
            this.putMetadata("RefRid", sm.refRid().orElse(""));
            this.putMetadata("SourceId", sm.sourceId().orElse(""));
            this.sourceMetadata(sm);
            return this;
        }

        public Builder maybeAddSourceMetadata(Optional<SourceMetadata> sm) {
            return sm.map(this::addSourceMetadata).orElse(this);
        }

        Builder withCurrentTraceId() {
            if (Tracer.hasTraceId()) {
                return this.requestTraceId(Tracer.getTraceId());
            }
            log.warn("No traceId found; this is unexpected and may indicate a Witchcraft bug.");
            return this;
        }
    }
}

