/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.resources;

import com.palantir.logsafe.UnsafeArg;
import java.nio.charset.StandardCharsets;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.com.google.common.io.BaseEncoding;
import shadow.palantir.driver.com.palantir.ri.ResourceIdentifier;
import shadow.palantir.driver.org.apache.commons.lang3.StringUtils;

public final class ContourResourceIdentifiers {
    public static final String APPLICATION_NAME = "contour";
    public static final String FOUNDRY_SERVICE_NAME = "foundry";
    public static final String TABLES_SERVICE_NAME = "tables";
    public static final String BELLASO_SERVICE_NAME = "bellaso";
    public static final String FOUNDRY_READ_DATA = "foundry:read-data";
    public static final String FOUNDRY_READ_FILES = "foundry:read-files";
    private static final String X32_PREFIX = "x32-";
    private static final BaseEncoding base32 = BaseEncoding.base32();
    public static final String DATASET_RI_TYPE = "dataset";
    public static final String TRANSACTION_RI_TYPE = "transaction";
    public static final String TABLE_RI_TYPE = "table";
    public static final String LICENSE_RI_TYPE = "cipher-license";

    private ContourResourceIdentifiers() {
    }

    public static ResourceIdentifier datasetRi(String instance, String id) {
        String maybeRid;
        String string = maybeRid = id.indexOf(58) == -1 ? id : id.substring(0, id.indexOf(58));
        if (maybeRid.startsWith("ri.foundry") || maybeRid.startsWith("ri.contour")) {
            return ResourceIdentifier.of(maybeRid);
        }
        return ResourceIdentifier.of(APPLICATION_NAME, instance, DATASET_RI_TYPE, X32_PREFIX + base32.encode(id.getBytes(StandardCharsets.UTF_8)).replace("=", ""));
    }

    public static boolean isFoundryDatasetRid(String possibleRid) {
        return ContourResourceIdentifiers.isValidRidWithServiceAndType(possibleRid, FOUNDRY_SERVICE_NAME, DATASET_RI_TYPE);
    }

    public static boolean isFoundryTransactionRid(String possibleRid) {
        return ContourResourceIdentifiers.isValidRidWithServiceAndType(possibleRid, FOUNDRY_SERVICE_NAME, TRANSACTION_RI_TYPE);
    }

    public static boolean isTableRid(String possibleRid) {
        return ContourResourceIdentifiers.isValidRidWithServiceAndType(possibleRid, TABLES_SERVICE_NAME, TABLE_RI_TYPE);
    }

    public static boolean isValidRidWithServiceAndType(String possibleRid, String service, String type) {
        if (ResourceIdentifier.isValid(possibleRid)) {
            ResourceIdentifier rid = ResourceIdentifier.of(possibleRid);
            return rid.getService().equals(service) && rid.getType().equals(type);
        }
        return false;
    }

    public static String combineRidAndBranch(ResourceIdentifier rid, String branch) {
        return String.format("%s:%s", rid.toString(), branch);
    }

    public static ResourceIdentifier datasetRidFromCombinedRidAndBranch(String ridAndBranch) {
        return ResourceIdentifier.of(ContourResourceIdentifiers.ridStringFromCombinedRidAndBranch(ridAndBranch));
    }

    public static String ridStringFromCombinedRidAndBranch(String ridAndBranch) {
        return StringUtils.substringBefore(ridAndBranch, ":");
    }

    public static String branchFromCombinedRidAndBranch(String ridAndBranch) {
        return StringUtils.substringAfter(ridAndBranch, ":");
    }

    public static ResourceIdentifier transactionRidFromString(String transaction) {
        ContourExceptions.server500Precondition(ContourResourceIdentifiers.isFoundryTransactionRid(transaction), "Expected a Foundry transaction rid, but didn't match correct format", UnsafeArg.of("nonFoundryTransaction", transaction));
        return ResourceIdentifier.of(transaction);
    }
}

