/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.results;

import com.palantir.foundry.stats.index.DatasetIndex;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import latitude.api.results.LatitudeResult;
import latitude.api.results.StatsIndexLatitudeResult;
import latitude.api.results.metadata.ResultComputationMetadata;
import latitude.api.results.metadata.ResultId;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;
import shadow.palantir.driver.org.joda.time.DateTime;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StatsIndexLatitudeResult", generator="Immutables")
@Immutable
public final class ImmutableStatsIndexLatitudeResult
extends StatsIndexLatitudeResult {
    private final DateTime computedTime;
    @Nullable
    private final String computedVersion;
    @Nullable
    private final String warningMessage;
    @Nullable
    private final ResultComputationMetadata resultComputationMetadata;
    @Nullable
    private final ResultId resultId;
    private final DatasetIndex datasetIndex;
    private final ImmutableMap<String, FoundryFieldSchema> foundryFieldSchemaByColumnIdentifier;

    private ImmutableStatsIndexLatitudeResult(Builder builder) {
        this.computedVersion = builder.computedVersion;
        this.warningMessage = builder.warningMessage;
        this.resultComputationMetadata = builder.resultComputationMetadata;
        this.resultId = builder.resultId;
        this.datasetIndex = builder.datasetIndex;
        this.foundryFieldSchemaByColumnIdentifier = builder.foundryFieldSchemaByColumnIdentifier.build();
        this.computedTime = builder.computedTime != null ? builder.computedTime : Objects.requireNonNull(super.getComputedTime(), "computedTime");
    }

    private ImmutableStatsIndexLatitudeResult(DateTime computedTime, @Nullable String computedVersion, @Nullable String warningMessage, @Nullable ResultComputationMetadata resultComputationMetadata, @Nullable ResultId resultId, DatasetIndex datasetIndex, ImmutableMap<String, FoundryFieldSchema> foundryFieldSchemaByColumnIdentifier) {
        this.computedTime = computedTime;
        this.computedVersion = computedVersion;
        this.warningMessage = warningMessage;
        this.resultComputationMetadata = resultComputationMetadata;
        this.resultId = resultId;
        this.datasetIndex = datasetIndex;
        this.foundryFieldSchemaByColumnIdentifier = foundryFieldSchemaByColumnIdentifier;
    }

    @Override
    @JsonProperty(value="computedTime")
    public DateTime getComputedTime() {
        return this.computedTime;
    }

    @Override
    @JsonProperty(value="computedVersion")
    public Optional<String> getComputedVersion() {
        return Optional.ofNullable(this.computedVersion);
    }

    @Override
    @JsonProperty(value="warningMessage")
    public Optional<String> getWarningMessage() {
        return Optional.ofNullable(this.warningMessage);
    }

    @Override
    @JsonProperty(value="resultComputationMetadata")
    public Optional<ResultComputationMetadata> getResultComputationMetadata() {
        return Optional.ofNullable(this.resultComputationMetadata);
    }

    @Override
    @JsonProperty(value="resultId")
    public Optional<ResultId> getResultId() {
        return Optional.ofNullable(this.resultId);
    }

    @Override
    @JsonProperty(value="datasetIndex")
    public DatasetIndex getDatasetIndex() {
        return this.datasetIndex;
    }

    @JsonProperty(value="foundryFieldSchemaByColumnIdentifier")
    public ImmutableMap<String, FoundryFieldSchema> getFoundryFieldSchemaByColumnIdentifier() {
        return this.foundryFieldSchemaByColumnIdentifier;
    }

    public final ImmutableStatsIndexLatitudeResult withComputedTime(DateTime value) {
        if (this.computedTime == value) {
            return this;
        }
        DateTime newValue = Objects.requireNonNull(value, "computedTime");
        return new ImmutableStatsIndexLatitudeResult(newValue, this.computedVersion, this.warningMessage, this.resultComputationMetadata, this.resultId, this.datasetIndex, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsIndexLatitudeResult withComputedVersion(String value) {
        String newValue = Objects.requireNonNull(value, "computedVersion");
        if (Objects.equals(this.computedVersion, newValue)) {
            return this;
        }
        return new ImmutableStatsIndexLatitudeResult(this.computedTime, newValue, this.warningMessage, this.resultComputationMetadata, this.resultId, this.datasetIndex, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsIndexLatitudeResult withComputedVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.computedVersion, value)) {
            return this;
        }
        return new ImmutableStatsIndexLatitudeResult(this.computedTime, value, this.warningMessage, this.resultComputationMetadata, this.resultId, this.datasetIndex, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsIndexLatitudeResult withWarningMessage(String value) {
        String newValue = Objects.requireNonNull(value, "warningMessage");
        if (Objects.equals(this.warningMessage, newValue)) {
            return this;
        }
        return new ImmutableStatsIndexLatitudeResult(this.computedTime, this.computedVersion, newValue, this.resultComputationMetadata, this.resultId, this.datasetIndex, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsIndexLatitudeResult withWarningMessage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.warningMessage, value)) {
            return this;
        }
        return new ImmutableStatsIndexLatitudeResult(this.computedTime, this.computedVersion, value, this.resultComputationMetadata, this.resultId, this.datasetIndex, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsIndexLatitudeResult withResultComputationMetadata(ResultComputationMetadata value) {
        ResultComputationMetadata newValue = Objects.requireNonNull(value, "resultComputationMetadata");
        if (this.resultComputationMetadata == newValue) {
            return this;
        }
        return new ImmutableStatsIndexLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, newValue, this.resultId, this.datasetIndex, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsIndexLatitudeResult withResultComputationMetadata(Optional<? extends ResultComputationMetadata> optional) {
        ResultComputationMetadata value = optional.orElse(null);
        if (this.resultComputationMetadata == value) {
            return this;
        }
        return new ImmutableStatsIndexLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, value, this.resultId, this.datasetIndex, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsIndexLatitudeResult withResultId(ResultId value) {
        ResultId newValue = Objects.requireNonNull(value, "resultId");
        if (this.resultId == newValue) {
            return this;
        }
        return new ImmutableStatsIndexLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, this.resultComputationMetadata, newValue, this.datasetIndex, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsIndexLatitudeResult withResultId(Optional<? extends ResultId> optional) {
        ResultId value = optional.orElse(null);
        if (this.resultId == value) {
            return this;
        }
        return new ImmutableStatsIndexLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, this.resultComputationMetadata, value, this.datasetIndex, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsIndexLatitudeResult withDatasetIndex(DatasetIndex value) {
        if (this.datasetIndex == value) {
            return this;
        }
        DatasetIndex newValue = Objects.requireNonNull(value, "datasetIndex");
        return new ImmutableStatsIndexLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, this.resultComputationMetadata, this.resultId, newValue, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsIndexLatitudeResult withFoundryFieldSchemaByColumnIdentifier(Map<String, ? extends FoundryFieldSchema> entries) {
        if (this.foundryFieldSchemaByColumnIdentifier == entries) {
            return this;
        }
        ImmutableMap<String, FoundryFieldSchema> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableStatsIndexLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, this.resultComputationMetadata, this.resultId, this.datasetIndex, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsIndexLatitudeResult && this.equalTo(0, (ImmutableStatsIndexLatitudeResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatsIndexLatitudeResult another) {
        return Objects.equals(this.computedVersion, another.computedVersion) && Objects.equals(this.warningMessage, another.warningMessage) && Objects.equals(this.resultComputationMetadata, another.resultComputationMetadata) && Objects.equals(this.resultId, another.resultId) && this.datasetIndex.equals(another.datasetIndex) && this.foundryFieldSchemaByColumnIdentifier.equals(another.foundryFieldSchemaByColumnIdentifier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.computedVersion);
        h += (h << 5) + Objects.hashCode(this.warningMessage);
        h += (h << 5) + Objects.hashCode(this.resultComputationMetadata);
        h += (h << 5) + Objects.hashCode(this.resultId);
        h += (h << 5) + this.datasetIndex.hashCode();
        h += (h << 5) + this.foundryFieldSchemaByColumnIdentifier.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StatsIndexLatitudeResult").omitNullValues().add("computedVersion", this.computedVersion).add("warningMessage", this.warningMessage).add("resultComputationMetadata", this.resultComputationMetadata).add("resultId", this.resultId).add("datasetIndex", this.datasetIndex).add("foundryFieldSchemaByColumnIdentifier", this.foundryFieldSchemaByColumnIdentifier).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStatsIndexLatitudeResult fromJson(Json json) {
        StatsIndexLatitudeResult.Builder builder = new StatsIndexLatitudeResult.Builder();
        if (json.computedTime != null) {
            builder.computedTime(json.computedTime);
        }
        if (json.computedVersion != null) {
            builder.computedVersion(json.computedVersion);
        }
        if (json.warningMessage != null) {
            builder.warningMessage(json.warningMessage);
        }
        if (json.resultComputationMetadata != null) {
            builder.resultComputationMetadata(json.resultComputationMetadata);
        }
        if (json.resultId != null) {
            builder.resultId(json.resultId);
        }
        if (json.datasetIndex != null) {
            builder.datasetIndex(json.datasetIndex);
        }
        if (json.foundryFieldSchemaByColumnIdentifier != null) {
            builder.putAllFoundryFieldSchemaByColumnIdentifier(json.foundryFieldSchemaByColumnIdentifier);
        }
        return builder.build();
    }

    public static ImmutableStatsIndexLatitudeResult copyOf(StatsIndexLatitudeResult instance) {
        if (instance instanceof ImmutableStatsIndexLatitudeResult) {
            return (ImmutableStatsIndexLatitudeResult)instance;
        }
        return new StatsIndexLatitudeResult.Builder().from(instance).build();
    }

    @Generated(from="StatsIndexLatitudeResult", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_DATASET_INDEX = 1L;
        private long initBits = 1L;
        @Nullable
        private DateTime computedTime;
        @Nullable
        private String computedVersion;
        @Nullable
        private String warningMessage;
        @Nullable
        private ResultComputationMetadata resultComputationMetadata;
        @Nullable
        private ResultId resultId;
        @Nullable
        private DatasetIndex datasetIndex;
        private ImmutableMap.Builder<String, FoundryFieldSchema> foundryFieldSchemaByColumnIdentifier = ImmutableMap.builder();

        public Builder() {
            if (!(this instanceof StatsIndexLatitudeResult.Builder)) {
                throw new UnsupportedOperationException("Use: new StatsIndexLatitudeResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder from(StatsIndexLatitudeResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder from(LatitudeResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return (StatsIndexLatitudeResult.Builder)this;
        }

        private void from(short _unused, Object object) {
            LatitudeResult instance;
            if (object instanceof StatsIndexLatitudeResult) {
                instance = (StatsIndexLatitudeResult)object;
                this.datasetIndex(((StatsIndexLatitudeResult)instance).getDatasetIndex());
                this.putAllFoundryFieldSchemaByColumnIdentifier(((StatsIndexLatitudeResult)instance).getFoundryFieldSchemaByColumnIdentifier());
            }
            if (object instanceof LatitudeResult) {
                Optional<ResultComputationMetadata> resultComputationMetadataOptional;
                Optional<String> computedVersionOptional;
                instance = (LatitudeResult)object;
                Optional<String> warningMessageOptional = instance.getWarningMessage();
                if (warningMessageOptional.isPresent()) {
                    this.warningMessage(warningMessageOptional);
                }
                this.computedTime(instance.getComputedTime());
                Optional<ResultId> resultIdOptional = instance.getResultId();
                if (resultIdOptional.isPresent()) {
                    this.resultId(resultIdOptional);
                }
                if ((computedVersionOptional = instance.getComputedVersion()).isPresent()) {
                    this.computedVersion(computedVersionOptional);
                }
                if ((resultComputationMetadataOptional = instance.getResultComputationMetadata()).isPresent()) {
                    this.resultComputationMetadata(resultComputationMetadataOptional);
                }
            }
        }

        @JsonProperty(value="computedTime")
        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder computedTime(DateTime computedTime) {
            this.computedTime = Objects.requireNonNull(computedTime, "computedTime");
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder computedVersion(String computedVersion) {
            this.computedVersion = Objects.requireNonNull(computedVersion, "computedVersion");
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @JsonProperty(value="computedVersion")
        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder computedVersion(Optional<String> computedVersion) {
            this.computedVersion = computedVersion.orElse(null);
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder warningMessage(String warningMessage) {
            this.warningMessage = Objects.requireNonNull(warningMessage, "warningMessage");
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @JsonProperty(value="warningMessage")
        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder warningMessage(Optional<String> warningMessage) {
            this.warningMessage = warningMessage.orElse(null);
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder resultComputationMetadata(ResultComputationMetadata resultComputationMetadata) {
            this.resultComputationMetadata = Objects.requireNonNull(resultComputationMetadata, "resultComputationMetadata");
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @JsonProperty(value="resultComputationMetadata")
        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder resultComputationMetadata(Optional<? extends ResultComputationMetadata> resultComputationMetadata) {
            this.resultComputationMetadata = resultComputationMetadata.orElse(null);
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder resultId(ResultId resultId) {
            this.resultId = Objects.requireNonNull(resultId, "resultId");
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @JsonProperty(value="resultId")
        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder resultId(Optional<? extends ResultId> resultId) {
            this.resultId = resultId.orElse(null);
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @JsonProperty(value="datasetIndex")
        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder datasetIndex(DatasetIndex datasetIndex) {
            this.datasetIndex = Objects.requireNonNull(datasetIndex, "datasetIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder putFoundryFieldSchemaByColumnIdentifier(String key, FoundryFieldSchema value) {
            this.foundryFieldSchemaByColumnIdentifier.put(key, value);
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder putFoundryFieldSchemaByColumnIdentifier(Map.Entry<String, ? extends FoundryFieldSchema> entry) {
            this.foundryFieldSchemaByColumnIdentifier.put(entry);
            return (StatsIndexLatitudeResult.Builder)this;
        }

        @JsonProperty(value="foundryFieldSchemaByColumnIdentifier")
        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder foundryFieldSchemaByColumnIdentifier(Map<String, ? extends FoundryFieldSchema> entries) {
            this.foundryFieldSchemaByColumnIdentifier = ImmutableMap.builder();
            return this.putAllFoundryFieldSchemaByColumnIdentifier(entries);
        }

        @CanIgnoreReturnValue
        public final StatsIndexLatitudeResult.Builder putAllFoundryFieldSchemaByColumnIdentifier(Map<String, ? extends FoundryFieldSchema> entries) {
            this.foundryFieldSchemaByColumnIdentifier.putAll(entries);
            return (StatsIndexLatitudeResult.Builder)this;
        }

        public ImmutableStatsIndexLatitudeResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsIndexLatitudeResult(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("datasetIndex");
            }
            return "Cannot build StatsIndexLatitudeResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StatsIndexLatitudeResult", generator="Immutables")
    static final class Json
    extends StatsIndexLatitudeResult {
        @Nullable
        DateTime computedTime;
        @Nullable
        Optional<String> computedVersion = Optional.empty();
        @Nullable
        Optional<String> warningMessage = Optional.empty();
        @Nullable
        Optional<ResultComputationMetadata> resultComputationMetadata = Optional.empty();
        @Nullable
        Optional<ResultId> resultId = Optional.empty();
        @Nullable
        DatasetIndex datasetIndex;
        @Nullable
        Map<String, FoundryFieldSchema> foundryFieldSchemaByColumnIdentifier = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="computedTime")
        public void setComputedTime(DateTime computedTime) {
            this.computedTime = computedTime;
        }

        @JsonProperty(value="computedVersion")
        public void setComputedVersion(Optional<String> computedVersion) {
            this.computedVersion = computedVersion;
        }

        @JsonProperty(value="warningMessage")
        public void setWarningMessage(Optional<String> warningMessage) {
            this.warningMessage = warningMessage;
        }

        @JsonProperty(value="resultComputationMetadata")
        public void setResultComputationMetadata(Optional<ResultComputationMetadata> resultComputationMetadata) {
            this.resultComputationMetadata = resultComputationMetadata;
        }

        @JsonProperty(value="resultId")
        public void setResultId(Optional<ResultId> resultId) {
            this.resultId = resultId;
        }

        @JsonProperty(value="datasetIndex")
        public void setDatasetIndex(DatasetIndex datasetIndex) {
            this.datasetIndex = datasetIndex;
        }

        @JsonProperty(value="foundryFieldSchemaByColumnIdentifier")
        public void setFoundryFieldSchemaByColumnIdentifier(Map<String, FoundryFieldSchema> foundryFieldSchemaByColumnIdentifier) {
            this.foundryFieldSchemaByColumnIdentifier = foundryFieldSchemaByColumnIdentifier;
        }

        @Override
        public DateTime getComputedTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getComputedVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getWarningMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResultComputationMetadata> getResultComputationMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResultId> getResultId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DatasetIndex getDatasetIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, FoundryFieldSchema> getFoundryFieldSchemaByColumnIdentifier() {
            throw new UnsupportedOperationException();
        }
    }
}

