/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.results;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import latitude.api.results.LatitudeResult;
import latitude.api.results.StatsLatitudeResult;
import latitude.api.results.metadata.ResultComputationMetadata;
import latitude.api.results.metadata.ResultId;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.DatasetStats;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;
import shadow.palantir.driver.org.joda.time.DateTime;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StatsLatitudeResult", generator="Immutables")
@Immutable
public final class ImmutableStatsLatitudeResult
extends StatsLatitudeResult {
    private final DateTime computedTime;
    @Nullable
    private final String computedVersion;
    @Nullable
    private final String warningMessage;
    @Nullable
    private final ResultComputationMetadata resultComputationMetadata;
    @Nullable
    private final ResultId resultId;
    private final DatasetStats datasetStats;
    @Nullable
    private final Map<String, FoundryFieldSchema> foundryFieldSchemaByColumnIdentifier;

    private ImmutableStatsLatitudeResult(Builder builder) {
        this.computedVersion = builder.computedVersion;
        this.warningMessage = builder.warningMessage;
        this.resultComputationMetadata = builder.resultComputationMetadata;
        this.resultId = builder.resultId;
        this.datasetStats = builder.datasetStats;
        this.foundryFieldSchemaByColumnIdentifier = builder.foundryFieldSchemaByColumnIdentifier;
        this.computedTime = builder.computedTime != null ? builder.computedTime : Objects.requireNonNull(super.getComputedTime(), "computedTime");
    }

    private ImmutableStatsLatitudeResult(DateTime computedTime, @Nullable String computedVersion, @Nullable String warningMessage, @Nullable ResultComputationMetadata resultComputationMetadata, @Nullable ResultId resultId, DatasetStats datasetStats, @Nullable Map<String, FoundryFieldSchema> foundryFieldSchemaByColumnIdentifier) {
        this.computedTime = computedTime;
        this.computedVersion = computedVersion;
        this.warningMessage = warningMessage;
        this.resultComputationMetadata = resultComputationMetadata;
        this.resultId = resultId;
        this.datasetStats = datasetStats;
        this.foundryFieldSchemaByColumnIdentifier = foundryFieldSchemaByColumnIdentifier;
    }

    @Override
    @JsonProperty(value="computedTime")
    public DateTime getComputedTime() {
        return this.computedTime;
    }

    @Override
    @JsonProperty(value="computedVersion")
    public Optional<String> getComputedVersion() {
        return Optional.ofNullable(this.computedVersion);
    }

    @Override
    @JsonProperty(value="warningMessage")
    public Optional<String> getWarningMessage() {
        return Optional.ofNullable(this.warningMessage);
    }

    @Override
    @JsonProperty(value="resultComputationMetadata")
    public Optional<ResultComputationMetadata> getResultComputationMetadata() {
        return Optional.ofNullable(this.resultComputationMetadata);
    }

    @Override
    @JsonProperty(value="resultId")
    public Optional<ResultId> getResultId() {
        return Optional.ofNullable(this.resultId);
    }

    @Override
    @JsonProperty(value="datasetStats")
    public DatasetStats getDatasetStats() {
        return this.datasetStats;
    }

    @Override
    @JsonProperty(value="foundryFieldSchemaByColumnIdentifier")
    public Optional<Map<String, FoundryFieldSchema>> getFoundryFieldSchemaByColumnIdentifier() {
        return Optional.ofNullable(this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withComputedTime(DateTime value) {
        if (this.computedTime == value) {
            return this;
        }
        DateTime newValue = Objects.requireNonNull(value, "computedTime");
        return new ImmutableStatsLatitudeResult(newValue, this.computedVersion, this.warningMessage, this.resultComputationMetadata, this.resultId, this.datasetStats, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withComputedVersion(String value) {
        String newValue = Objects.requireNonNull(value, "computedVersion");
        if (Objects.equals(this.computedVersion, newValue)) {
            return this;
        }
        return new ImmutableStatsLatitudeResult(this.computedTime, newValue, this.warningMessage, this.resultComputationMetadata, this.resultId, this.datasetStats, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withComputedVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.computedVersion, value)) {
            return this;
        }
        return new ImmutableStatsLatitudeResult(this.computedTime, value, this.warningMessage, this.resultComputationMetadata, this.resultId, this.datasetStats, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withWarningMessage(String value) {
        String newValue = Objects.requireNonNull(value, "warningMessage");
        if (Objects.equals(this.warningMessage, newValue)) {
            return this;
        }
        return new ImmutableStatsLatitudeResult(this.computedTime, this.computedVersion, newValue, this.resultComputationMetadata, this.resultId, this.datasetStats, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withWarningMessage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.warningMessage, value)) {
            return this;
        }
        return new ImmutableStatsLatitudeResult(this.computedTime, this.computedVersion, value, this.resultComputationMetadata, this.resultId, this.datasetStats, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withResultComputationMetadata(ResultComputationMetadata value) {
        ResultComputationMetadata newValue = Objects.requireNonNull(value, "resultComputationMetadata");
        if (this.resultComputationMetadata == newValue) {
            return this;
        }
        return new ImmutableStatsLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, newValue, this.resultId, this.datasetStats, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withResultComputationMetadata(Optional<? extends ResultComputationMetadata> optional) {
        ResultComputationMetadata value = optional.orElse(null);
        if (this.resultComputationMetadata == value) {
            return this;
        }
        return new ImmutableStatsLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, value, this.resultId, this.datasetStats, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withResultId(ResultId value) {
        ResultId newValue = Objects.requireNonNull(value, "resultId");
        if (this.resultId == newValue) {
            return this;
        }
        return new ImmutableStatsLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, this.resultComputationMetadata, newValue, this.datasetStats, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withResultId(Optional<? extends ResultId> optional) {
        ResultId value = optional.orElse(null);
        if (this.resultId == value) {
            return this;
        }
        return new ImmutableStatsLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, this.resultComputationMetadata, value, this.datasetStats, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withDatasetStats(DatasetStats value) {
        if (this.datasetStats == value) {
            return this;
        }
        DatasetStats newValue = Objects.requireNonNull(value, "datasetStats");
        return new ImmutableStatsLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, this.resultComputationMetadata, this.resultId, newValue, this.foundryFieldSchemaByColumnIdentifier);
    }

    public final ImmutableStatsLatitudeResult withFoundryFieldSchemaByColumnIdentifier(Map<String, FoundryFieldSchema> value) {
        Map<String, FoundryFieldSchema> newValue = Objects.requireNonNull(value, "foundryFieldSchemaByColumnIdentifier");
        if (this.foundryFieldSchemaByColumnIdentifier == newValue) {
            return this;
        }
        return new ImmutableStatsLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, this.resultComputationMetadata, this.resultId, this.datasetStats, newValue);
    }

    public final ImmutableStatsLatitudeResult withFoundryFieldSchemaByColumnIdentifier(Optional<? extends Map<String, FoundryFieldSchema>> optional) {
        Map value = optional.orElse(null);
        if (this.foundryFieldSchemaByColumnIdentifier == value) {
            return this;
        }
        return new ImmutableStatsLatitudeResult(this.computedTime, this.computedVersion, this.warningMessage, this.resultComputationMetadata, this.resultId, this.datasetStats, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStatsLatitudeResult && this.equalTo(0, (ImmutableStatsLatitudeResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableStatsLatitudeResult another) {
        return Objects.equals(this.computedVersion, another.computedVersion) && Objects.equals(this.warningMessage, another.warningMessage) && Objects.equals(this.resultComputationMetadata, another.resultComputationMetadata) && Objects.equals(this.resultId, another.resultId) && this.datasetStats.equals(another.datasetStats) && Objects.equals(this.foundryFieldSchemaByColumnIdentifier, another.foundryFieldSchemaByColumnIdentifier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.computedVersion);
        h += (h << 5) + Objects.hashCode(this.warningMessage);
        h += (h << 5) + Objects.hashCode(this.resultComputationMetadata);
        h += (h << 5) + Objects.hashCode(this.resultId);
        h += (h << 5) + this.datasetStats.hashCode();
        h += (h << 5) + Objects.hashCode(this.foundryFieldSchemaByColumnIdentifier);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StatsLatitudeResult").omitNullValues().add("computedVersion", this.computedVersion).add("warningMessage", this.warningMessage).add("resultComputationMetadata", this.resultComputationMetadata).add("resultId", this.resultId).add("datasetStats", this.datasetStats).add("foundryFieldSchemaByColumnIdentifier", this.foundryFieldSchemaByColumnIdentifier).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStatsLatitudeResult fromJson(Json json) {
        StatsLatitudeResult.Builder builder = new StatsLatitudeResult.Builder();
        if (json.computedTime != null) {
            builder.computedTime(json.computedTime);
        }
        if (json.computedVersion != null) {
            builder.computedVersion(json.computedVersion);
        }
        if (json.warningMessage != null) {
            builder.warningMessage(json.warningMessage);
        }
        if (json.resultComputationMetadata != null) {
            builder.resultComputationMetadata(json.resultComputationMetadata);
        }
        if (json.resultId != null) {
            builder.resultId(json.resultId);
        }
        if (json.datasetStats != null) {
            builder.datasetStats(json.datasetStats);
        }
        if (json.foundryFieldSchemaByColumnIdentifier != null) {
            builder.foundryFieldSchemaByColumnIdentifier(json.foundryFieldSchemaByColumnIdentifier);
        }
        return builder.build();
    }

    public static ImmutableStatsLatitudeResult copyOf(StatsLatitudeResult instance) {
        if (instance instanceof ImmutableStatsLatitudeResult) {
            return (ImmutableStatsLatitudeResult)instance;
        }
        return new StatsLatitudeResult.Builder().from(instance).build();
    }

    @Generated(from="StatsLatitudeResult", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_DATASET_STATS = 1L;
        private long initBits = 1L;
        @Nullable
        private DateTime computedTime;
        @Nullable
        private String computedVersion;
        @Nullable
        private String warningMessage;
        @Nullable
        private ResultComputationMetadata resultComputationMetadata;
        @Nullable
        private ResultId resultId;
        @Nullable
        private DatasetStats datasetStats;
        @Nullable
        private Map<String, FoundryFieldSchema> foundryFieldSchemaByColumnIdentifier;

        public Builder() {
            if (!(this instanceof StatsLatitudeResult.Builder)) {
                throw new UnsupportedOperationException("Use: new StatsLatitudeResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder from(LatitudeResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return (StatsLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder from(StatsLatitudeResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return (StatsLatitudeResult.Builder)this;
        }

        private void from(short _unused, Object object) {
            LatitudeResult instance;
            if (object instanceof LatitudeResult) {
                Optional<ResultComputationMetadata> resultComputationMetadataOptional;
                Optional<String> computedVersionOptional;
                instance = (LatitudeResult)object;
                Optional<String> warningMessageOptional = instance.getWarningMessage();
                if (warningMessageOptional.isPresent()) {
                    this.warningMessage(warningMessageOptional);
                }
                this.computedTime(instance.getComputedTime());
                Optional<ResultId> resultIdOptional = instance.getResultId();
                if (resultIdOptional.isPresent()) {
                    this.resultId(resultIdOptional);
                }
                if ((computedVersionOptional = instance.getComputedVersion()).isPresent()) {
                    this.computedVersion(computedVersionOptional);
                }
                if ((resultComputationMetadataOptional = instance.getResultComputationMetadata()).isPresent()) {
                    this.resultComputationMetadata(resultComputationMetadataOptional);
                }
            }
            if (object instanceof StatsLatitudeResult) {
                instance = (StatsLatitudeResult)object;
                Optional<Map<String, FoundryFieldSchema>> foundryFieldSchemaByColumnIdentifierOptional = ((StatsLatitudeResult)instance).getFoundryFieldSchemaByColumnIdentifier();
                if (foundryFieldSchemaByColumnIdentifierOptional.isPresent()) {
                    this.foundryFieldSchemaByColumnIdentifier(foundryFieldSchemaByColumnIdentifierOptional);
                }
                this.datasetStats(((StatsLatitudeResult)instance).getDatasetStats());
            }
        }

        @JsonProperty(value="computedTime")
        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder computedTime(DateTime computedTime) {
            this.computedTime = Objects.requireNonNull(computedTime, "computedTime");
            return (StatsLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder computedVersion(String computedVersion) {
            this.computedVersion = Objects.requireNonNull(computedVersion, "computedVersion");
            return (StatsLatitudeResult.Builder)this;
        }

        @JsonProperty(value="computedVersion")
        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder computedVersion(Optional<String> computedVersion) {
            this.computedVersion = computedVersion.orElse(null);
            return (StatsLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder warningMessage(String warningMessage) {
            this.warningMessage = Objects.requireNonNull(warningMessage, "warningMessage");
            return (StatsLatitudeResult.Builder)this;
        }

        @JsonProperty(value="warningMessage")
        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder warningMessage(Optional<String> warningMessage) {
            this.warningMessage = warningMessage.orElse(null);
            return (StatsLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder resultComputationMetadata(ResultComputationMetadata resultComputationMetadata) {
            this.resultComputationMetadata = Objects.requireNonNull(resultComputationMetadata, "resultComputationMetadata");
            return (StatsLatitudeResult.Builder)this;
        }

        @JsonProperty(value="resultComputationMetadata")
        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder resultComputationMetadata(Optional<? extends ResultComputationMetadata> resultComputationMetadata) {
            this.resultComputationMetadata = resultComputationMetadata.orElse(null);
            return (StatsLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder resultId(ResultId resultId) {
            this.resultId = Objects.requireNonNull(resultId, "resultId");
            return (StatsLatitudeResult.Builder)this;
        }

        @JsonProperty(value="resultId")
        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder resultId(Optional<? extends ResultId> resultId) {
            this.resultId = resultId.orElse(null);
            return (StatsLatitudeResult.Builder)this;
        }

        @JsonProperty(value="datasetStats")
        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder datasetStats(DatasetStats datasetStats) {
            this.datasetStats = Objects.requireNonNull(datasetStats, "datasetStats");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (StatsLatitudeResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder foundryFieldSchemaByColumnIdentifier(Map<String, FoundryFieldSchema> foundryFieldSchemaByColumnIdentifier) {
            this.foundryFieldSchemaByColumnIdentifier = Objects.requireNonNull(foundryFieldSchemaByColumnIdentifier, "foundryFieldSchemaByColumnIdentifier");
            return (StatsLatitudeResult.Builder)this;
        }

        @JsonProperty(value="foundryFieldSchemaByColumnIdentifier")
        @CanIgnoreReturnValue
        public final StatsLatitudeResult.Builder foundryFieldSchemaByColumnIdentifier(Optional<? extends Map<String, FoundryFieldSchema>> foundryFieldSchemaByColumnIdentifier) {
            this.foundryFieldSchemaByColumnIdentifier = foundryFieldSchemaByColumnIdentifier.orElse(null);
            return (StatsLatitudeResult.Builder)this;
        }

        public ImmutableStatsLatitudeResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStatsLatitudeResult(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("datasetStats");
            }
            return "Cannot build StatsLatitudeResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StatsLatitudeResult", generator="Immutables")
    static final class Json
    extends StatsLatitudeResult {
        @Nullable
        DateTime computedTime;
        @Nullable
        Optional<String> computedVersion = Optional.empty();
        @Nullable
        Optional<String> warningMessage = Optional.empty();
        @Nullable
        Optional<ResultComputationMetadata> resultComputationMetadata = Optional.empty();
        @Nullable
        Optional<ResultId> resultId = Optional.empty();
        @Nullable
        DatasetStats datasetStats;
        @Nullable
        Optional<Map<String, FoundryFieldSchema>> foundryFieldSchemaByColumnIdentifier = Optional.empty();

        Json() {
        }

        @JsonProperty(value="computedTime")
        public void setComputedTime(DateTime computedTime) {
            this.computedTime = computedTime;
        }

        @JsonProperty(value="computedVersion")
        public void setComputedVersion(Optional<String> computedVersion) {
            this.computedVersion = computedVersion;
        }

        @JsonProperty(value="warningMessage")
        public void setWarningMessage(Optional<String> warningMessage) {
            this.warningMessage = warningMessage;
        }

        @JsonProperty(value="resultComputationMetadata")
        public void setResultComputationMetadata(Optional<ResultComputationMetadata> resultComputationMetadata) {
            this.resultComputationMetadata = resultComputationMetadata;
        }

        @JsonProperty(value="resultId")
        public void setResultId(Optional<ResultId> resultId) {
            this.resultId = resultId;
        }

        @JsonProperty(value="datasetStats")
        public void setDatasetStats(DatasetStats datasetStats) {
            this.datasetStats = datasetStats;
        }

        @JsonProperty(value="foundryFieldSchemaByColumnIdentifier")
        public void setFoundryFieldSchemaByColumnIdentifier(Optional<Map<String, FoundryFieldSchema>> foundryFieldSchemaByColumnIdentifier) {
            this.foundryFieldSchemaByColumnIdentifier = foundryFieldSchemaByColumnIdentifier;
        }

        @Override
        public DateTime getComputedTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getComputedVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getWarningMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResultComputationMetadata> getResultComputationMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResultId> getResultId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DatasetStats getDatasetStats() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, FoundryFieldSchema>> getFoundryFieldSchemaByColumnIdentifier() {
            throw new UnsupportedOperationException();
        }
    }
}

