/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.results;

import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.OptionalLong;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ApproximateGaussianValue;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ApproximateGenericValue;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.ExactValue;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.Value;

public final class LongValueExtractor
implements Value.Visitor<OptionalLong> {
    private static final SafeLogger log = SafeLoggerFactory.get(LongValueExtractor.class);
    public static final LongValueExtractor INSTANCE = new LongValueExtractor();

    private LongValueExtractor() {
    }

    @Override
    public OptionalLong visitExactValue(ExactValue exactValue) {
        String exactString = exactValue.getValue();
        try {
            long value = Long.parseLong(exactString);
            return OptionalLong.of(value);
        }
        catch (NumberFormatException e) {
            log.warn("Unable to get row count, DatasetStats had non-numeric value for row count.", UnsafeArg.of("invalidRowCount", exactString), (Throwable)e);
            return OptionalLong.empty();
        }
    }

    @Override
    public OptionalLong visitApproximateGenericValue(ApproximateGenericValue approximateGenericValue) {
        log.warn("Unable to get row count, DatasetStats had approximate value for row count", UnsafeArg.of("approximateGenericValue", approximateGenericValue));
        return OptionalLong.empty();
    }

    @Override
    public OptionalLong visitApproximateGaussianValue(ApproximateGaussianValue approximateGaussianValue) {
        log.warn("Unable to get row count, DatasetStats had approximate value for row count", UnsafeArg.of("approximateGaussianValue", approximateGaussianValue));
        return OptionalLong.empty();
    }

    @Override
    public OptionalLong visitUnknown(String unknown) {
        log.warn("Unable to get row count, DatasetStats had approximate value for row count", UnsafeArg.of("unknown", unknown));
        return OptionalLong.empty();
    }
}

