/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.results;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Unsafe;
import java.util.Map;
import java.util.Optional;
import latitude.api.exception.ContourExceptions;
import latitude.api.results.ImmutableStatsLatitudeResult;
import latitude.api.results.LatitudeResult;
import latitude.api.results.LatitudeResultVisitor;
import latitude.api.results.LongValueExtractor;
import latitude.api.results.ThrowingLatitudeResultVisitor;
import latitude.api.results.metadata.ResultId;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.com.palantir.foundry.stats.service.api.DatasetStats;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@JsonSerialize(as=ImmutableStatsLatitudeResult.class)
@JsonDeserialize(as=ImmutableStatsLatitudeResult.class)
@JsonTypeName(value="stats")
@Value.Immutable
public abstract class StatsLatitudeResult
extends LatitudeResult {
    public abstract DatasetStats getDatasetStats();

    public abstract Optional<Map<String, FoundryFieldSchema>> getFoundryFieldSchemaByColumnIdentifier();

    @JsonIgnore
    public long getRowCount() {
        return this.getDatasetStats().getRowCount().accept(LongValueExtractor.INSTANCE).orElseThrow(() -> ContourExceptions.server500("Unable to get row count from DatasetStats.", new Arg[0]));
    }

    @Override
    @Unsafe
    public LatitudeResult withRandomIdAndNoComputationMetadata() {
        return StatsLatitudeResult.builder().from(this).resultComputationMetadata(Optional.empty()).resultId(ResultId.random()).build();
    }

    @Override
    public <T, V extends LatitudeResultVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T, V extends ThrowingLatitudeResultVisitor<T, E>, E extends Exception> T accept(V visitor) throws E {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableStatsLatitudeResult.Builder {
    }
}

