/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.results;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import latitude.api.results.LatitudeResult;
import latitude.api.results.LatitudeResultVisitor;
import latitude.api.results.PrimaryKeyInformation;
import latitude.api.results.TableLatitudeResult;
import latitude.api.results.TableLatitudeResultV2;
import latitude.api.results.TableLatitudeResultVisitor;
import latitude.api.results.ThrowingLatitudeResultVisitor;
import latitude.api.results.metadata.ResultComputationMetadata;
import latitude.api.results.metadata.ResultId;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.palantir.foundry.schemas.api.types.FoundryFieldSchema;
import shadow.palantir.driver.org.joda.time.DateTime;

@Deprecated
@JsonTypeName(value="table")
public final class TableLatitudeResultV1
extends TableLatitudeResult {
    private final List<String> columns;
    private final List<FoundryFieldSchema> columnTypes;
    private final Map<String, Map<Integer, Object>> results;
    private final int rowCount;
    private final DateTime computedTime;
    private final Optional<String> computedVersion;
    private final Optional<ResultComputationMetadata> resultComputationMetadata;
    private final Optional<ResultId> resultId;
    private final Optional<String> warningMessage;
    private final Optional<PrimaryKeyInformation> primaryKeyInformation;

    @Override
    public TableLatitudeResultV2 asLatestVersion() {
        ArrayList resultsAsList = new ArrayList(this.columns.size());
        for (int i = 0; i < this.columns.size(); ++i) {
            resultsAsList.add(new ArrayList(this.rowCount));
        }
        for (int columnIndex = 0; columnIndex < this.columns.size(); ++columnIndex) {
            for (int rowIndex = 0; rowIndex < this.rowCount; ++rowIndex) {
                Object value = this.results.get(this.columns.get(columnIndex)).get(rowIndex);
                ((List)resultsAsList.get(columnIndex)).add(value);
            }
        }
        return TableLatitudeResultV2.builder().columns(this.columns).primaryKeyInformation(this.primaryKeyInformation).columnTypes(this.columnTypes).results(resultsAsList).rowCount(this.rowCount).computedTime(this.getComputedTime()).computedVersion(this.getComputedVersion()).resultComputationMetadata(this.getResultComputationMetadata()).resultId(this.getResultId()).warningMessage(this.warningMessage).build();
    }

    public TableLatitudeResultV1(@JsonProperty(value="columns") List<String> columns, @JsonProperty(value="columnTypes") List<FoundryFieldSchema> columnTypes, @JsonProperty(value="results") Map<String, Map<Integer, Object>> results, @JsonProperty(value="resultSize") int rowCount, @JsonProperty(value="computedTime") DateTime computedTime, @JsonProperty(value="computedVersion") Optional<String> computedVersion, @JsonProperty(value="resultComputationMetadata") Optional<ResultComputationMetadata> resultComputationMetadata, @JsonProperty(value="resultId") Optional<ResultId> resultId, @JsonProperty(value="warningMessage") Optional<String> warningMessage, @JsonProperty(value="primaryKeyInformation") Optional<PrimaryKeyInformation> primaryKeyInformation) {
        this.computedTime = computedTime;
        this.computedVersion = computedVersion;
        this.columns = columns;
        this.primaryKeyInformation = primaryKeyInformation;
        this.columnTypes = columnTypes;
        this.results = results;
        this.rowCount = rowCount;
        this.resultComputationMetadata = resultComputationMetadata;
        this.resultId = resultId;
        this.warningMessage = warningMessage;
    }

    public Map<String, Map<Integer, Object>> getResults() {
        return this.results;
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getRowAsColumnNameToValueMap(int rowNumber) {
        ImmutableMap.Builder<String, Object> row = ImmutableMap.builder();
        for (Map.Entry<String, Map<Integer, Object>> col : this.results.entrySet()) {
            Object value = col.getValue().get(rowNumber);
            if (value == null) continue;
            row.put(col.getKey(), value);
        }
        return row.buildOrThrow();
    }

    @Override
    @JsonIgnore
    public List<Object> getColumnAsList(final String columnName) {
        return new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                return TableLatitudeResultV1.this.results.get(columnName).get(index);
            }

            @Override
            public int size() {
                return TableLatitudeResultV1.this.rowCount;
            }
        };
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Optional<PrimaryKeyInformation> getPrimaryKeyInformation() {
        return this.primaryKeyInformation;
    }

    @Override
    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public List<FoundryFieldSchema> getColumnTypes() {
        return this.columnTypes;
    }

    @Override
    public DateTime getComputedTime() {
        return this.computedTime;
    }

    @Override
    public Optional<String> getComputedVersion() {
        return this.computedVersion;
    }

    @Override
    public Optional<String> getWarningMessage() {
        return this.warningMessage;
    }

    @Override
    public Optional<ResultComputationMetadata> getResultComputationMetadata() {
        return this.resultComputationMetadata;
    }

    @Override
    public Optional<ResultId> getResultId() {
        return this.resultId;
    }

    @Override
    public LatitudeResult withRandomIdAndNoComputationMetadata() {
        return new TableLatitudeResultV1(this.columns, this.columnTypes, this.results, this.rowCount, this.computedTime, this.computedVersion, Optional.empty(), Optional.of(ResultId.random()), this.warningMessage, this.primaryKeyInformation);
    }

    @Override
    public <T, V extends LatitudeResultVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T, V extends ThrowingLatitudeResultVisitor<T, E>, E extends Exception> T accept(V visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public <T, V extends TableLatitudeResultVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableLatitudeResultV1 that = (TableLatitudeResultV1)obj;
        return this.rowCount == that.rowCount && Objects.equals(this.columns, that.columns) && Objects.equals(this.columnTypes, that.columnTypes) && Objects.equals(this.results, that.results) && Objects.equals(this.getComputedVersion(), that.getComputedVersion()) && Objects.equals(this.getWarningMessage(), that.getWarningMessage()) && Objects.equals(this.primaryKeyInformation, that.primaryKeyInformation);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.columnTypes, this.results, this.rowCount, this.getComputedVersion(), this.getWarningMessage(), this.primaryKeyInformation);
    }
}

