/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.results;

import com.palantir.logsafe.Unsafe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import latitude.api.results.ImmutableTableLatitudeResultV2;
import latitude.api.results.LatitudeResult;
import latitude.api.results.LatitudeResultVisitor;
import latitude.api.results.TableLatitudeResult;
import latitude.api.results.TableLatitudeResultVisitor;
import latitude.api.results.ThrowingLatitudeResultVisitor;
import latitude.api.results.metadata.ResultId;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.google.common.collect.Maps;
import shadow.palantir.driver.one.util.streamex.StreamEx;
import shadow.palantir.driver.org.immutables.value.Value;

@Unsafe
@JsonSerialize(as=ImmutableTableLatitudeResultV2.class)
@JsonDeserialize(as=ImmutableTableLatitudeResultV2.class)
@JsonTypeName(value="tablev2")
@Value.Immutable
public abstract class TableLatitudeResultV2
extends TableLatitudeResult {
    public abstract List<List<Object>> getResults();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    protected Map<String, Integer> columnNameToIndex() {
        HashMap<String, Integer> columnNameToIndex = Maps.newHashMapWithExpectedSize(this.getColumns().size());
        for (int i = 0; i < this.getColumns().size(); ++i) {
            columnNameToIndex.put(this.getColumns().get(i), i);
        }
        return columnNameToIndex;
    }

    @Override
    public TableLatitudeResultV2 asLatestVersion() {
        return this;
    }

    @Override
    public List<Object> getColumnAsList(String columnName) {
        return this.getResults().get(this.columnNameToIndex().get(columnName));
    }

    @Override
    public Map<String, Object> getRowAsColumnNameToValueMap(int rowNumber) {
        return StreamEx.of(this.getColumns()).mapToEntry(this::getColumnAsList).filterValues(columnList -> rowNumber < columnList.size()).filterValues(columnList -> columnList.get(rowNumber) != null).mapValues(columnList -> columnList.get(rowNumber)).toMap();
    }

    @Override
    @Unsafe
    public LatitudeResult withRandomIdAndNoComputationMetadata() {
        return TableLatitudeResultV2.builder().from(this).resultComputationMetadata(Optional.empty()).resultId(ResultId.random()).build();
    }

    @Override
    public <T, V extends LatitudeResultVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T, V extends ThrowingLatitudeResultVisitor<T, E>, E extends Exception> T accept(V visitor) throws E {
        return visitor.visit(this);
    }

    @Override
    public <T, V extends TableLatitudeResultVisitor<T>> T accept(V visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableTableLatitudeResultV2.Builder {
    }
}

