/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.results.metadata;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import latitude.api.description.LatitudeSetDescription;
import latitude.api.query.LatitudeQueryDescription;
import latitude.api.results.metadata.ComplexDataframeResolutionType;
import latitude.api.results.metadata.InitialDataframeResolutionType;
import latitude.api.results.metadata.ResultComputationMetadata;
import latitude.api.results.metadata.ResultComputationMetadataCacheType;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ResultComputationMetadata", generator="Immutables")
@Immutable
public final class ImmutableResultComputationMetadata
extends ResultComputationMetadata {
    @Nullable
    private final Long submitTimeMillis;
    @Nullable
    private final Long startTimeMillis;
    @Nullable
    private final Long finishResolveDataFrameTimeMillis;
    @Nullable
    private final Long finishTimeMillis;
    @Nullable
    private final Long estimatedResultSizeOnHeapInBytes;
    private final ResultComputationMetadataCacheType cacheType;
    @Nullable
    private final InitialDataframeResolutionType initialDataframeResolutionType;
    @Nullable
    private final ComplexDataframeResolutionType complexDataframeResolutionType;
    private final LatitudeSetDescription setDescription;
    @Nullable
    private final String traceId;
    @Nullable
    private final String saveTraceId;
    @Nullable
    private final LatitudeQueryDescription latitudeQueryDescription;
    @Nullable
    private final String backendMetricsTag;
    @Nullable
    private final String backendGroupMetricsTag;
    @Nullable
    private final String groupProducerMetricsTag;
    @Nullable
    private final Integer numberOfTasks;
    @Nullable
    private final Integer numberOfStages;

    private ImmutableResultComputationMetadata(@Nullable Long submitTimeMillis, @Nullable Long startTimeMillis, @Nullable Long finishResolveDataFrameTimeMillis, @Nullable Long finishTimeMillis, @Nullable Long estimatedResultSizeOnHeapInBytes, ResultComputationMetadataCacheType cacheType, @Nullable InitialDataframeResolutionType initialDataframeResolutionType, @Nullable ComplexDataframeResolutionType complexDataframeResolutionType, LatitudeSetDescription setDescription, @Nullable String traceId, @Nullable String saveTraceId, @Nullable LatitudeQueryDescription latitudeQueryDescription, @Nullable String backendMetricsTag, @Nullable String backendGroupMetricsTag, @Nullable String groupProducerMetricsTag, @Nullable Integer numberOfTasks, @Nullable Integer numberOfStages) {
        this.submitTimeMillis = submitTimeMillis;
        this.startTimeMillis = startTimeMillis;
        this.finishResolveDataFrameTimeMillis = finishResolveDataFrameTimeMillis;
        this.finishTimeMillis = finishTimeMillis;
        this.estimatedResultSizeOnHeapInBytes = estimatedResultSizeOnHeapInBytes;
        this.cacheType = cacheType;
        this.initialDataframeResolutionType = initialDataframeResolutionType;
        this.complexDataframeResolutionType = complexDataframeResolutionType;
        this.setDescription = setDescription;
        this.traceId = traceId;
        this.saveTraceId = saveTraceId;
        this.latitudeQueryDescription = latitudeQueryDescription;
        this.backendMetricsTag = backendMetricsTag;
        this.backendGroupMetricsTag = backendGroupMetricsTag;
        this.groupProducerMetricsTag = groupProducerMetricsTag;
        this.numberOfTasks = numberOfTasks;
        this.numberOfStages = numberOfStages;
    }

    @Override
    @JsonProperty(value="submitTimeMillis")
    public OptionalLong submitTimeMillis() {
        return this.submitTimeMillis != null ? OptionalLong.of(this.submitTimeMillis) : OptionalLong.empty();
    }

    @Override
    @JsonProperty(value="startTimeMillis")
    public OptionalLong startTimeMillis() {
        return this.startTimeMillis != null ? OptionalLong.of(this.startTimeMillis) : OptionalLong.empty();
    }

    @Override
    @JsonProperty(value="finishResolveDataFrameTimeMillis")
    public OptionalLong finishResolveDataFrameTimeMillis() {
        return this.finishResolveDataFrameTimeMillis != null ? OptionalLong.of(this.finishResolveDataFrameTimeMillis) : OptionalLong.empty();
    }

    @Override
    @JsonProperty(value="finishTimeMillis")
    public OptionalLong finishTimeMillis() {
        return this.finishTimeMillis != null ? OptionalLong.of(this.finishTimeMillis) : OptionalLong.empty();
    }

    @Override
    @JsonProperty(value="estimatedResultSizeOnHeapInBytes")
    public Optional<Long> estimatedResultSizeOnHeapInBytes() {
        return Optional.ofNullable(this.estimatedResultSizeOnHeapInBytes);
    }

    @Override
    @JsonProperty(value="cacheType")
    public ResultComputationMetadataCacheType cacheType() {
        return this.cacheType;
    }

    @Override
    @JsonProperty(value="initialDataframeResolutionType")
    public Optional<InitialDataframeResolutionType> initialDataframeResolutionType() {
        return Optional.ofNullable(this.initialDataframeResolutionType);
    }

    @Override
    @JsonProperty(value="complexDataframeResolutionType")
    public Optional<ComplexDataframeResolutionType> complexDataframeResolutionType() {
        return Optional.ofNullable(this.complexDataframeResolutionType);
    }

    @Override
    @JsonProperty(value="setDescription")
    public LatitudeSetDescription setDescription() {
        return this.setDescription;
    }

    @Override
    @JsonProperty(value="traceId")
    public Optional<String> traceId() {
        return Optional.ofNullable(this.traceId);
    }

    @Override
    @JsonProperty(value="saveTraceId")
    public Optional<String> saveTraceId() {
        return Optional.ofNullable(this.saveTraceId);
    }

    @Override
    @JsonProperty(value="latitudeQueryDescription")
    public Optional<LatitudeQueryDescription> latitudeQueryDescription() {
        return Optional.ofNullable(this.latitudeQueryDescription);
    }

    @Override
    @JsonProperty(value="backendMetricsTag")
    public Optional<String> backendMetricsTag() {
        return Optional.ofNullable(this.backendMetricsTag);
    }

    @Override
    @JsonProperty(value="backendGroupMetricsTag")
    public Optional<String> backendGroupMetricsTag() {
        return Optional.ofNullable(this.backendGroupMetricsTag);
    }

    @Override
    @JsonProperty(value="groupProducerMetricsTag")
    public Optional<String> groupProducerMetricsTag() {
        return Optional.ofNullable(this.groupProducerMetricsTag);
    }

    @Override
    @JsonProperty(value="numberOfTasks")
    public Optional<Integer> numberOfTasks() {
        return Optional.ofNullable(this.numberOfTasks);
    }

    @Override
    @JsonProperty(value="numberOfStages")
    public Optional<Integer> numberOfStages() {
        return Optional.ofNullable(this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withSubmitTimeMillis(long value) {
        Long newValue = value;
        if (Objects.equals(this.submitTimeMillis, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(newValue, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withSubmitTimeMillis(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.submitTimeMillis, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(value, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withStartTimeMillis(long value) {
        Long newValue = value;
        if (Objects.equals(this.startTimeMillis, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, newValue, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withStartTimeMillis(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.startTimeMillis, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, value, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withFinishResolveDataFrameTimeMillis(long value) {
        Long newValue = value;
        if (Objects.equals(this.finishResolveDataFrameTimeMillis, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, newValue, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withFinishResolveDataFrameTimeMillis(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.finishResolveDataFrameTimeMillis, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, value, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withFinishTimeMillis(long value) {
        Long newValue = value;
        if (Objects.equals(this.finishTimeMillis, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, newValue, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withFinishTimeMillis(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.finishTimeMillis, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, value, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withEstimatedResultSizeOnHeapInBytes(long value) {
        Long newValue = value;
        if (Objects.equals(this.estimatedResultSizeOnHeapInBytes, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, newValue, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withEstimatedResultSizeOnHeapInBytes(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.estimatedResultSizeOnHeapInBytes, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, value, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withCacheType(ResultComputationMetadataCacheType value) {
        ResultComputationMetadataCacheType newValue = Objects.requireNonNull(value, "cacheType");
        if (this.cacheType == newValue) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, newValue, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withInitialDataframeResolutionType(InitialDataframeResolutionType value) {
        InitialDataframeResolutionType newValue = Objects.requireNonNull(value, "initialDataframeResolutionType");
        if (this.initialDataframeResolutionType == newValue) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, newValue, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withInitialDataframeResolutionType(Optional<? extends InitialDataframeResolutionType> optional) {
        InitialDataframeResolutionType value = optional.orElse(null);
        if (this.initialDataframeResolutionType == value) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, value, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withComplexDataframeResolutionType(ComplexDataframeResolutionType value) {
        ComplexDataframeResolutionType newValue = Objects.requireNonNull(value, "complexDataframeResolutionType");
        if (this.complexDataframeResolutionType == newValue) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, newValue, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withComplexDataframeResolutionType(Optional<? extends ComplexDataframeResolutionType> optional) {
        ComplexDataframeResolutionType value = optional.orElse(null);
        if (this.complexDataframeResolutionType == value) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, value, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withSetDescription(LatitudeSetDescription value) {
        if (this.setDescription == value) {
            return this;
        }
        LatitudeSetDescription newValue = Objects.requireNonNull(value, "setDescription");
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, newValue, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withTraceId(String value) {
        String newValue = Objects.requireNonNull(value, "traceId");
        if (Objects.equals(this.traceId, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, newValue, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withTraceId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.traceId, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, value, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withSaveTraceId(String value) {
        String newValue = Objects.requireNonNull(value, "saveTraceId");
        if (Objects.equals(this.saveTraceId, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, newValue, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withSaveTraceId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.saveTraceId, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, value, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withLatitudeQueryDescription(LatitudeQueryDescription value) {
        LatitudeQueryDescription newValue = Objects.requireNonNull(value, "latitudeQueryDescription");
        if (this.latitudeQueryDescription == newValue) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, newValue, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withLatitudeQueryDescription(Optional<? extends LatitudeQueryDescription> optional) {
        LatitudeQueryDescription value = optional.orElse(null);
        if (this.latitudeQueryDescription == value) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, value, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withBackendMetricsTag(String value) {
        String newValue = Objects.requireNonNull(value, "backendMetricsTag");
        if (Objects.equals(this.backendMetricsTag, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, newValue, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withBackendMetricsTag(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.backendMetricsTag, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, value, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withBackendGroupMetricsTag(String value) {
        String newValue = Objects.requireNonNull(value, "backendGroupMetricsTag");
        if (Objects.equals(this.backendGroupMetricsTag, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, newValue, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withBackendGroupMetricsTag(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.backendGroupMetricsTag, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, value, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withGroupProducerMetricsTag(String value) {
        String newValue = Objects.requireNonNull(value, "groupProducerMetricsTag");
        if (Objects.equals(this.groupProducerMetricsTag, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, newValue, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withGroupProducerMetricsTag(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.groupProducerMetricsTag, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, value, this.numberOfTasks, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withNumberOfTasks(int value) {
        Integer newValue = value;
        if (Objects.equals(this.numberOfTasks, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, newValue, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withNumberOfTasks(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.numberOfTasks, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, value, this.numberOfStages);
    }

    public final ImmutableResultComputationMetadata withNumberOfStages(int value) {
        Integer newValue = value;
        if (Objects.equals(this.numberOfStages, newValue)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, newValue);
    }

    public final ImmutableResultComputationMetadata withNumberOfStages(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.numberOfStages, value)) {
            return this;
        }
        return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResultComputationMetadata && this.equalTo(0, (ImmutableResultComputationMetadata)another);
    }

    private boolean equalTo(int synthetic, ImmutableResultComputationMetadata another) {
        return Objects.equals(this.submitTimeMillis, another.submitTimeMillis) && Objects.equals(this.startTimeMillis, another.startTimeMillis) && Objects.equals(this.finishResolveDataFrameTimeMillis, another.finishResolveDataFrameTimeMillis) && Objects.equals(this.finishTimeMillis, another.finishTimeMillis) && Objects.equals(this.estimatedResultSizeOnHeapInBytes, another.estimatedResultSizeOnHeapInBytes) && this.cacheType.equals((Object)another.cacheType) && Objects.equals((Object)this.initialDataframeResolutionType, (Object)another.initialDataframeResolutionType) && Objects.equals((Object)this.complexDataframeResolutionType, (Object)another.complexDataframeResolutionType) && this.setDescription.equals(another.setDescription) && Objects.equals(this.traceId, another.traceId) && Objects.equals(this.saveTraceId, another.saveTraceId) && Objects.equals(this.latitudeQueryDescription, another.latitudeQueryDescription) && Objects.equals(this.backendMetricsTag, another.backendMetricsTag) && Objects.equals(this.backendGroupMetricsTag, another.backendGroupMetricsTag) && Objects.equals(this.groupProducerMetricsTag, another.groupProducerMetricsTag) && Objects.equals(this.numberOfTasks, another.numberOfTasks) && Objects.equals(this.numberOfStages, another.numberOfStages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.submitTimeMillis);
        h += (h << 5) + Objects.hashCode(this.startTimeMillis);
        h += (h << 5) + Objects.hashCode(this.finishResolveDataFrameTimeMillis);
        h += (h << 5) + Objects.hashCode(this.finishTimeMillis);
        h += (h << 5) + Objects.hashCode(this.estimatedResultSizeOnHeapInBytes);
        h += (h << 5) + this.cacheType.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.initialDataframeResolutionType);
        h += (h << 5) + Objects.hashCode((Object)this.complexDataframeResolutionType);
        h += (h << 5) + this.setDescription.hashCode();
        h += (h << 5) + Objects.hashCode(this.traceId);
        h += (h << 5) + Objects.hashCode(this.saveTraceId);
        h += (h << 5) + Objects.hashCode(this.latitudeQueryDescription);
        h += (h << 5) + Objects.hashCode(this.backendMetricsTag);
        h += (h << 5) + Objects.hashCode(this.backendGroupMetricsTag);
        h += (h << 5) + Objects.hashCode(this.groupProducerMetricsTag);
        h += (h << 5) + Objects.hashCode(this.numberOfTasks);
        h += (h << 5) + Objects.hashCode(this.numberOfStages);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ResultComputationMetadata").omitNullValues().add("submitTimeMillis", this.submitTimeMillis).add("startTimeMillis", this.startTimeMillis).add("finishResolveDataFrameTimeMillis", this.finishResolveDataFrameTimeMillis).add("finishTimeMillis", this.finishTimeMillis).add("estimatedResultSizeOnHeapInBytes", this.estimatedResultSizeOnHeapInBytes).add("cacheType", (Object)this.cacheType).add("initialDataframeResolutionType", (Object)this.initialDataframeResolutionType).add("complexDataframeResolutionType", (Object)this.complexDataframeResolutionType).add("setDescription", this.setDescription).add("traceId", this.traceId).add("saveTraceId", this.saveTraceId).add("latitudeQueryDescription", this.latitudeQueryDescription).add("backendMetricsTag", this.backendMetricsTag).add("backendGroupMetricsTag", this.backendGroupMetricsTag).add("groupProducerMetricsTag", this.groupProducerMetricsTag).add("numberOfTasks", this.numberOfTasks).add("numberOfStages", this.numberOfStages).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableResultComputationMetadata fromJson(Json json) {
        ResultComputationMetadata.Builder builder = new ResultComputationMetadata.Builder();
        if (json.submitTimeMillis != null) {
            builder.submitTimeMillis(json.submitTimeMillis);
        }
        if (json.startTimeMillis != null) {
            builder.startTimeMillis(json.startTimeMillis);
        }
        if (json.finishResolveDataFrameTimeMillis != null) {
            builder.finishResolveDataFrameTimeMillis(json.finishResolveDataFrameTimeMillis);
        }
        if (json.finishTimeMillis != null) {
            builder.finishTimeMillis(json.finishTimeMillis);
        }
        if (json.estimatedResultSizeOnHeapInBytes != null) {
            builder.estimatedResultSizeOnHeapInBytes(json.estimatedResultSizeOnHeapInBytes);
        }
        if (json.cacheType != null) {
            builder.cacheType(json.cacheType);
        }
        if (json.initialDataframeResolutionType != null) {
            builder.initialDataframeResolutionType(json.initialDataframeResolutionType);
        }
        if (json.complexDataframeResolutionType != null) {
            builder.complexDataframeResolutionType(json.complexDataframeResolutionType);
        }
        if (json.setDescription != null) {
            builder.setDescription(json.setDescription);
        }
        if (json.traceId != null) {
            builder.traceId(json.traceId);
        }
        if (json.saveTraceId != null) {
            builder.saveTraceId(json.saveTraceId);
        }
        if (json.latitudeQueryDescription != null) {
            builder.latitudeQueryDescription(json.latitudeQueryDescription);
        }
        if (json.backendMetricsTag != null) {
            builder.backendMetricsTag(json.backendMetricsTag);
        }
        if (json.backendGroupMetricsTag != null) {
            builder.backendGroupMetricsTag(json.backendGroupMetricsTag);
        }
        if (json.groupProducerMetricsTag != null) {
            builder.groupProducerMetricsTag(json.groupProducerMetricsTag);
        }
        if (json.numberOfTasks != null) {
            builder.numberOfTasks(json.numberOfTasks);
        }
        if (json.numberOfStages != null) {
            builder.numberOfStages(json.numberOfStages);
        }
        return builder.build();
    }

    public static ImmutableResultComputationMetadata copyOf(ResultComputationMetadata instance) {
        if (instance instanceof ImmutableResultComputationMetadata) {
            return (ImmutableResultComputationMetadata)instance;
        }
        return new ResultComputationMetadata.Builder().from(instance).build();
    }

    @Generated(from="ResultComputationMetadata", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_CACHE_TYPE = 1L;
        private static final long INIT_BIT_SET_DESCRIPTION = 2L;
        private long initBits = 3L;
        @Nullable
        private Long submitTimeMillis;
        @Nullable
        private Long startTimeMillis;
        @Nullable
        private Long finishResolveDataFrameTimeMillis;
        @Nullable
        private Long finishTimeMillis;
        @Nullable
        private Long estimatedResultSizeOnHeapInBytes;
        @Nullable
        private ResultComputationMetadataCacheType cacheType;
        @Nullable
        private InitialDataframeResolutionType initialDataframeResolutionType;
        @Nullable
        private ComplexDataframeResolutionType complexDataframeResolutionType;
        @Nullable
        private LatitudeSetDescription setDescription;
        @Nullable
        private String traceId;
        @Nullable
        private String saveTraceId;
        @Nullable
        private LatitudeQueryDescription latitudeQueryDescription;
        @Nullable
        private String backendMetricsTag;
        @Nullable
        private String backendGroupMetricsTag;
        @Nullable
        private String groupProducerMetricsTag;
        @Nullable
        private Integer numberOfTasks;
        @Nullable
        private Integer numberOfStages;

        public Builder() {
            if (!(this instanceof ResultComputationMetadata.Builder)) {
                throw new UnsupportedOperationException("Use: new ResultComputationMetadata.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder from(ResultComputationMetadata instance) {
            Optional<Integer> numberOfStagesOptional;
            Optional<Integer> numberOfTasksOptional;
            Optional<String> groupProducerMetricsTagOptional;
            Optional<String> backendGroupMetricsTagOptional;
            Optional<String> backendMetricsTagOptional;
            Optional<LatitudeQueryDescription> latitudeQueryDescriptionOptional;
            Optional<String> saveTraceIdOptional;
            Optional<ComplexDataframeResolutionType> complexDataframeResolutionTypeOptional;
            Optional<Long> estimatedResultSizeOnHeapInBytesOptional;
            OptionalLong finishTimeMillisOptional;
            OptionalLong finishResolveDataFrameTimeMillisOptional;
            OptionalLong startTimeMillisOptional;
            Objects.requireNonNull(instance, "instance");
            OptionalLong submitTimeMillisOptional = instance.submitTimeMillis();
            if (submitTimeMillisOptional.isPresent()) {
                this.submitTimeMillis(submitTimeMillisOptional);
            }
            if ((startTimeMillisOptional = instance.startTimeMillis()).isPresent()) {
                this.startTimeMillis(startTimeMillisOptional);
            }
            if ((finishResolveDataFrameTimeMillisOptional = instance.finishResolveDataFrameTimeMillis()).isPresent()) {
                this.finishResolveDataFrameTimeMillis(finishResolveDataFrameTimeMillisOptional);
            }
            if ((finishTimeMillisOptional = instance.finishTimeMillis()).isPresent()) {
                this.finishTimeMillis(finishTimeMillisOptional);
            }
            if ((estimatedResultSizeOnHeapInBytesOptional = instance.estimatedResultSizeOnHeapInBytes()).isPresent()) {
                this.estimatedResultSizeOnHeapInBytes(estimatedResultSizeOnHeapInBytesOptional);
            }
            this.cacheType(instance.cacheType());
            Optional<InitialDataframeResolutionType> initialDataframeResolutionTypeOptional = instance.initialDataframeResolutionType();
            if (initialDataframeResolutionTypeOptional.isPresent()) {
                this.initialDataframeResolutionType(initialDataframeResolutionTypeOptional);
            }
            if ((complexDataframeResolutionTypeOptional = instance.complexDataframeResolutionType()).isPresent()) {
                this.complexDataframeResolutionType(complexDataframeResolutionTypeOptional);
            }
            this.setDescription(instance.setDescription());
            Optional<String> traceIdOptional = instance.traceId();
            if (traceIdOptional.isPresent()) {
                this.traceId(traceIdOptional);
            }
            if ((saveTraceIdOptional = instance.saveTraceId()).isPresent()) {
                this.saveTraceId(saveTraceIdOptional);
            }
            if ((latitudeQueryDescriptionOptional = instance.latitudeQueryDescription()).isPresent()) {
                this.latitudeQueryDescription(latitudeQueryDescriptionOptional);
            }
            if ((backendMetricsTagOptional = instance.backendMetricsTag()).isPresent()) {
                this.backendMetricsTag(backendMetricsTagOptional);
            }
            if ((backendGroupMetricsTagOptional = instance.backendGroupMetricsTag()).isPresent()) {
                this.backendGroupMetricsTag(backendGroupMetricsTagOptional);
            }
            if ((groupProducerMetricsTagOptional = instance.groupProducerMetricsTag()).isPresent()) {
                this.groupProducerMetricsTag(groupProducerMetricsTagOptional);
            }
            if ((numberOfTasksOptional = instance.numberOfTasks()).isPresent()) {
                this.numberOfTasks(numberOfTasksOptional);
            }
            if ((numberOfStagesOptional = instance.numberOfStages()).isPresent()) {
                this.numberOfStages(numberOfStagesOptional);
            }
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder submitTimeMillis(long submitTimeMillis) {
            this.submitTimeMillis = submitTimeMillis;
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="submitTimeMillis")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder submitTimeMillis(OptionalLong submitTimeMillis) {
            this.submitTimeMillis = submitTimeMillis.isPresent() ? Long.valueOf(submitTimeMillis.getAsLong()) : null;
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder startTimeMillis(long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="startTimeMillis")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder startTimeMillis(OptionalLong startTimeMillis) {
            this.startTimeMillis = startTimeMillis.isPresent() ? Long.valueOf(startTimeMillis.getAsLong()) : null;
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder finishResolveDataFrameTimeMillis(long finishResolveDataFrameTimeMillis) {
            this.finishResolveDataFrameTimeMillis = finishResolveDataFrameTimeMillis;
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="finishResolveDataFrameTimeMillis")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder finishResolveDataFrameTimeMillis(OptionalLong finishResolveDataFrameTimeMillis) {
            this.finishResolveDataFrameTimeMillis = finishResolveDataFrameTimeMillis.isPresent() ? Long.valueOf(finishResolveDataFrameTimeMillis.getAsLong()) : null;
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder finishTimeMillis(long finishTimeMillis) {
            this.finishTimeMillis = finishTimeMillis;
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="finishTimeMillis")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder finishTimeMillis(OptionalLong finishTimeMillis) {
            this.finishTimeMillis = finishTimeMillis.isPresent() ? Long.valueOf(finishTimeMillis.getAsLong()) : null;
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder estimatedResultSizeOnHeapInBytes(long estimatedResultSizeOnHeapInBytes) {
            this.estimatedResultSizeOnHeapInBytes = estimatedResultSizeOnHeapInBytes;
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="estimatedResultSizeOnHeapInBytes")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder estimatedResultSizeOnHeapInBytes(Optional<Long> estimatedResultSizeOnHeapInBytes) {
            this.estimatedResultSizeOnHeapInBytes = estimatedResultSizeOnHeapInBytes.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="cacheType")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder cacheType(ResultComputationMetadataCacheType cacheType) {
            this.cacheType = Objects.requireNonNull(cacheType, "cacheType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder initialDataframeResolutionType(InitialDataframeResolutionType initialDataframeResolutionType) {
            this.initialDataframeResolutionType = Objects.requireNonNull(initialDataframeResolutionType, "initialDataframeResolutionType");
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="initialDataframeResolutionType")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder initialDataframeResolutionType(Optional<? extends InitialDataframeResolutionType> initialDataframeResolutionType) {
            this.initialDataframeResolutionType = initialDataframeResolutionType.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder complexDataframeResolutionType(ComplexDataframeResolutionType complexDataframeResolutionType) {
            this.complexDataframeResolutionType = Objects.requireNonNull(complexDataframeResolutionType, "complexDataframeResolutionType");
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="complexDataframeResolutionType")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder complexDataframeResolutionType(Optional<? extends ComplexDataframeResolutionType> complexDataframeResolutionType) {
            this.complexDataframeResolutionType = complexDataframeResolutionType.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="setDescription")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder setDescription(LatitudeSetDescription setDescription) {
            this.setDescription = Objects.requireNonNull(setDescription, "setDescription");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder traceId(String traceId) {
            this.traceId = Objects.requireNonNull(traceId, "traceId");
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="traceId")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder traceId(Optional<String> traceId) {
            this.traceId = traceId.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder saveTraceId(String saveTraceId) {
            this.saveTraceId = Objects.requireNonNull(saveTraceId, "saveTraceId");
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="saveTraceId")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder saveTraceId(Optional<String> saveTraceId) {
            this.saveTraceId = saveTraceId.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder latitudeQueryDescription(LatitudeQueryDescription latitudeQueryDescription) {
            this.latitudeQueryDescription = Objects.requireNonNull(latitudeQueryDescription, "latitudeQueryDescription");
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="latitudeQueryDescription")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder latitudeQueryDescription(Optional<? extends LatitudeQueryDescription> latitudeQueryDescription) {
            this.latitudeQueryDescription = latitudeQueryDescription.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder backendMetricsTag(String backendMetricsTag) {
            this.backendMetricsTag = Objects.requireNonNull(backendMetricsTag, "backendMetricsTag");
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="backendMetricsTag")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder backendMetricsTag(Optional<String> backendMetricsTag) {
            this.backendMetricsTag = backendMetricsTag.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder backendGroupMetricsTag(String backendGroupMetricsTag) {
            this.backendGroupMetricsTag = Objects.requireNonNull(backendGroupMetricsTag, "backendGroupMetricsTag");
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="backendGroupMetricsTag")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder backendGroupMetricsTag(Optional<String> backendGroupMetricsTag) {
            this.backendGroupMetricsTag = backendGroupMetricsTag.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder groupProducerMetricsTag(String groupProducerMetricsTag) {
            this.groupProducerMetricsTag = Objects.requireNonNull(groupProducerMetricsTag, "groupProducerMetricsTag");
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="groupProducerMetricsTag")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder groupProducerMetricsTag(Optional<String> groupProducerMetricsTag) {
            this.groupProducerMetricsTag = groupProducerMetricsTag.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder numberOfTasks(int numberOfTasks) {
            this.numberOfTasks = numberOfTasks;
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="numberOfTasks")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder numberOfTasks(Optional<Integer> numberOfTasks) {
            this.numberOfTasks = numberOfTasks.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder numberOfStages(int numberOfStages) {
            this.numberOfStages = numberOfStages;
            return (ResultComputationMetadata.Builder)this;
        }

        @JsonProperty(value="numberOfStages")
        @CanIgnoreReturnValue
        public final ResultComputationMetadata.Builder numberOfStages(Optional<Integer> numberOfStages) {
            this.numberOfStages = numberOfStages.orElse(null);
            return (ResultComputationMetadata.Builder)this;
        }

        public ImmutableResultComputationMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResultComputationMetadata(this.submitTimeMillis, this.startTimeMillis, this.finishResolveDataFrameTimeMillis, this.finishTimeMillis, this.estimatedResultSizeOnHeapInBytes, this.cacheType, this.initialDataframeResolutionType, this.complexDataframeResolutionType, this.setDescription, this.traceId, this.saveTraceId, this.latitudeQueryDescription, this.backendMetricsTag, this.backendGroupMetricsTag, this.groupProducerMetricsTag, this.numberOfTasks, this.numberOfStages);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cacheType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("setDescription");
            }
            return "Cannot build ResultComputationMetadata, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ResultComputationMetadata", generator="Immutables")
    static final class Json
    extends ResultComputationMetadata {
        @Nullable
        OptionalLong submitTimeMillis = OptionalLong.empty();
        @Nullable
        OptionalLong startTimeMillis = OptionalLong.empty();
        @Nullable
        OptionalLong finishResolveDataFrameTimeMillis = OptionalLong.empty();
        @Nullable
        OptionalLong finishTimeMillis = OptionalLong.empty();
        @Nullable
        Optional<Long> estimatedResultSizeOnHeapInBytes = Optional.empty();
        @Nullable
        ResultComputationMetadataCacheType cacheType;
        @Nullable
        Optional<InitialDataframeResolutionType> initialDataframeResolutionType = Optional.empty();
        @Nullable
        Optional<ComplexDataframeResolutionType> complexDataframeResolutionType = Optional.empty();
        @Nullable
        LatitudeSetDescription setDescription;
        @Nullable
        Optional<String> traceId = Optional.empty();
        @Nullable
        Optional<String> saveTraceId = Optional.empty();
        @Nullable
        Optional<LatitudeQueryDescription> latitudeQueryDescription = Optional.empty();
        @Nullable
        Optional<String> backendMetricsTag = Optional.empty();
        @Nullable
        Optional<String> backendGroupMetricsTag = Optional.empty();
        @Nullable
        Optional<String> groupProducerMetricsTag = Optional.empty();
        @Nullable
        Optional<Integer> numberOfTasks = Optional.empty();
        @Nullable
        Optional<Integer> numberOfStages = Optional.empty();

        Json() {
        }

        @JsonProperty(value="submitTimeMillis")
        public void setSubmitTimeMillis(OptionalLong submitTimeMillis) {
            this.submitTimeMillis = submitTimeMillis;
        }

        @JsonProperty(value="startTimeMillis")
        public void setStartTimeMillis(OptionalLong startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
        }

        @JsonProperty(value="finishResolveDataFrameTimeMillis")
        public void setFinishResolveDataFrameTimeMillis(OptionalLong finishResolveDataFrameTimeMillis) {
            this.finishResolveDataFrameTimeMillis = finishResolveDataFrameTimeMillis;
        }

        @JsonProperty(value="finishTimeMillis")
        public void setFinishTimeMillis(OptionalLong finishTimeMillis) {
            this.finishTimeMillis = finishTimeMillis;
        }

        @JsonProperty(value="estimatedResultSizeOnHeapInBytes")
        public void setEstimatedResultSizeOnHeapInBytes(Optional<Long> estimatedResultSizeOnHeapInBytes) {
            this.estimatedResultSizeOnHeapInBytes = estimatedResultSizeOnHeapInBytes;
        }

        @JsonProperty(value="cacheType")
        public void setCacheType(ResultComputationMetadataCacheType cacheType) {
            this.cacheType = cacheType;
        }

        @JsonProperty(value="initialDataframeResolutionType")
        public void setInitialDataframeResolutionType(Optional<InitialDataframeResolutionType> initialDataframeResolutionType) {
            this.initialDataframeResolutionType = initialDataframeResolutionType;
        }

        @JsonProperty(value="complexDataframeResolutionType")
        public void setComplexDataframeResolutionType(Optional<ComplexDataframeResolutionType> complexDataframeResolutionType) {
            this.complexDataframeResolutionType = complexDataframeResolutionType;
        }

        @JsonProperty(value="setDescription")
        public void setSetDescription(LatitudeSetDescription setDescription) {
            this.setDescription = setDescription;
        }

        @JsonProperty(value="traceId")
        public void setTraceId(Optional<String> traceId) {
            this.traceId = traceId;
        }

        @JsonProperty(value="saveTraceId")
        public void setSaveTraceId(Optional<String> saveTraceId) {
            this.saveTraceId = saveTraceId;
        }

        @JsonProperty(value="latitudeQueryDescription")
        public void setLatitudeQueryDescription(Optional<LatitudeQueryDescription> latitudeQueryDescription) {
            this.latitudeQueryDescription = latitudeQueryDescription;
        }

        @JsonProperty(value="backendMetricsTag")
        public void setBackendMetricsTag(Optional<String> backendMetricsTag) {
            this.backendMetricsTag = backendMetricsTag;
        }

        @JsonProperty(value="backendGroupMetricsTag")
        public void setBackendGroupMetricsTag(Optional<String> backendGroupMetricsTag) {
            this.backendGroupMetricsTag = backendGroupMetricsTag;
        }

        @JsonProperty(value="groupProducerMetricsTag")
        public void setGroupProducerMetricsTag(Optional<String> groupProducerMetricsTag) {
            this.groupProducerMetricsTag = groupProducerMetricsTag;
        }

        @JsonProperty(value="numberOfTasks")
        public void setNumberOfTasks(Optional<Integer> numberOfTasks) {
            this.numberOfTasks = numberOfTasks;
        }

        @JsonProperty(value="numberOfStages")
        public void setNumberOfStages(Optional<Integer> numberOfStages) {
            this.numberOfStages = numberOfStages;
        }

        @Override
        public OptionalLong submitTimeMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalLong startTimeMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalLong finishResolveDataFrameTimeMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalLong finishTimeMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> estimatedResultSizeOnHeapInBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultComputationMetadataCacheType cacheType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<InitialDataframeResolutionType> initialDataframeResolutionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ComplexDataframeResolutionType> complexDataframeResolutionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LatitudeSetDescription setDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> traceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> saveTraceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LatitudeQueryDescription> latitudeQueryDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> backendMetricsTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> backendGroupMetricsTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> groupProducerMetricsTag() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> numberOfTasks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> numberOfStages() {
            throw new UnsupportedOperationException();
        }
    }
}

