/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.results.metadata;

import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.Optional;
import java.util.OptionalLong;
import latitude.api.description.LatitudeSetDescription;
import latitude.api.query.LatitudeQueryDescription;
import latitude.api.results.metadata.ComplexDataframeResolutionType;
import latitude.api.results.metadata.ImmutableResultComputationMetadata;
import latitude.api.results.metadata.InitialDataframeResolutionType;
import latitude.api.results.metadata.ResultComputationMetadataCacheType;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.palantir.tracing.Tracer;
import shadow.palantir.driver.org.immutables.value.Value;

@JsonSerialize(as=ImmutableResultComputationMetadata.class)
@JsonDeserialize(as=ImmutableResultComputationMetadata.class)
@Value.Immutable
public abstract class ResultComputationMetadata {
    private static final SafeLogger log = SafeLoggerFactory.get(ResultComputationMetadata.class);

    public abstract OptionalLong submitTimeMillis();

    public abstract OptionalLong startTimeMillis();

    public abstract OptionalLong finishResolveDataFrameTimeMillis();

    public abstract OptionalLong finishTimeMillis();

    public abstract Optional<Long> estimatedResultSizeOnHeapInBytes();

    public abstract ResultComputationMetadataCacheType cacheType();

    public abstract Optional<InitialDataframeResolutionType> initialDataframeResolutionType();

    public abstract Optional<ComplexDataframeResolutionType> complexDataframeResolutionType();

    public abstract LatitudeSetDescription setDescription();

    public abstract Optional<String> traceId();

    public abstract Optional<String> saveTraceId();

    public abstract Optional<LatitudeQueryDescription> latitudeQueryDescription();

    public abstract Optional<String> backendMetricsTag();

    public abstract Optional<String> backendGroupMetricsTag();

    public abstract Optional<String> groupProducerMetricsTag();

    public abstract Optional<Integer> numberOfTasks();

    public abstract Optional<Integer> numberOfStages();

    public final ResultComputationMetadata withCurrentTraceIdAsSaveTraceId() {
        if (Tracer.hasTraceId()) {
            return new Builder().from(this).saveTraceId(Tracer.getTraceId()).build();
        }
        log.warn("No traceId found when saving; this is unexpected and may indicate a Witchcraft bug.");
        return this;
    }

    public static Builder builder() {
        if (Tracer.hasTraceId()) {
            return new Builder().traceId(Tracer.getTraceId());
        }
        log.warn("No traceId found when building; this is unexpected and may indicate a Witchcraft bug.");
        return new Builder();
    }

    public static class Builder
    extends ImmutableResultComputationMetadata.Builder {
    }
}

