/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.util;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import java.util.Optional;
import latitude.api.exception.ContourExceptions;

public final class CastUtils {
    private CastUtils() {
    }

    public static <T> T safeCastObjectAsClass(Object value, Class<T> clazz) {
        Optional<Boolean> possiblyParsed;
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        if (Number.class.isAssignableFrom(clazz)) {
            Optional<T> possiblyConverted;
            if (value instanceof String) {
                Optional<T> possiblyParsed2 = CastUtils.tryParseStringAsNumber((String)value, clazz);
                if (possiblyParsed2.isPresent()) {
                    return possiblyParsed2.get();
                }
            } else if (value instanceof Number && (possiblyConverted = CastUtils.tryConvertNumber((Number)value, clazz)).isPresent()) {
                return possiblyConverted.get();
            }
        } else if (Boolean.class.isAssignableFrom(clazz) && value instanceof String && (possiblyParsed = CastUtils.tryParseStringAsBoolean((String)value)).isPresent()) {
            return (T)possiblyParsed.get();
        }
        throw ContourExceptions.server500("Could not resolve argument as desired cast type.", UnsafeArg.of("illegalArgument", value), SafeArg.of("actualClassName", value.getClass().getSimpleName()), SafeArg.of("desiredClassName", clazz.getSimpleName()));
    }

    private static <T> Optional<T> tryParseStringAsNumber(String str, Class<T> clazz) {
        try {
            if (clazz == Integer.class) {
                return Optional.of(Integer.valueOf(str));
            }
            if (clazz == Double.class) {
                return Optional.of(Double.valueOf(str));
            }
            if (clazz == Long.class) {
                return Optional.of(Long.valueOf(str));
            }
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static Optional<Boolean> tryParseStringAsBoolean(String str) {
        if (str.equalsIgnoreCase("true")) {
            return Optional.of(true);
        }
        if (str.equalsIgnoreCase("false")) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private static <T> Optional<T> tryConvertNumber(Number num, Class<T> clazz) {
        if (clazz == Integer.class) {
            return Optional.of(num.intValue());
        }
        if (clazz == Double.class) {
            return Optional.of(num.doubleValue());
        }
        if (clazz == Long.class) {
            return Optional.of(num.longValue());
        }
        return Optional.empty();
    }
}

