/*
 * Decompiled with CFR 0.152.
 */
package latitude.api.util;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import latitude.api.exception.ContourExceptions;
import shadow.palantir.driver.org.joda.time.DateTimeZone;

public final class TimeZones {
    private TimeZones() {
    }

    public static String validateAndNormalizeTimezone(String timeZone, String columnNameForLogging) {
        ContourExceptions.client400CheckNotNullWithSafeMessage(timeZone, "timeZone must not be null", new Arg[0]);
        String normalizedTimezone = timeZone.equals("US/Pacific-New") ? "America/Los_Angeles" : timeZone;
        ContourExceptions.client400Precondition(DateTimeZone.getAvailableIDs().contains(normalizedTimezone), String.format("Time zone of '%s' provided with column '%s' was not a valid time zone id.", normalizedTimezone, columnNameForLogging), "Provided time zone was not a valid time zone id.", SafeArg.of("timeZone", normalizedTimezone), UnsafeArg.of("columnName", columnNameForLogging));
        return normalizedTimezone;
    }

    public static String validateAndNormalizeTimezone(String timeZone) {
        return TimeZones.validateAndNormalizeTimezone(timeZone, "N/A");
    }
}

