/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.auth0.jwt;

import shadow.palantir.driver.com.auth0.jwt.exceptions.JWTDecodeException;

abstract class TokenUtils {
    TokenUtils() {
    }

    static String[] splitToken(String token) throws JWTDecodeException {
        if (token == null) {
            throw new JWTDecodeException("The token is null.");
        }
        int delimiter = 46;
        int firstPeriodIndex = token.indexOf(delimiter);
        if (firstPeriodIndex == -1) {
            throw TokenUtils.wrongNumberOfParts(0);
        }
        int secondPeriodIndex = token.indexOf(delimiter, firstPeriodIndex + 1);
        if (secondPeriodIndex == -1) {
            throw TokenUtils.wrongNumberOfParts(2);
        }
        if (token.indexOf(delimiter, secondPeriodIndex + 1) != -1) {
            throw TokenUtils.wrongNumberOfParts("> 3");
        }
        String[] parts = new String[]{token.substring(0, firstPeriodIndex), token.substring(firstPeriodIndex + 1, secondPeriodIndex), token.substring(secondPeriodIndex + 1)};
        return parts;
    }

    private static JWTDecodeException wrongNumberOfParts(Object partCount) {
        return new JWTDecodeException(String.format("The token was expected to have 3 parts, but got %s.", partCount));
    }
}

