/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.auth0.jwt.algorithms;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import shadow.palantir.driver.com.auth0.jwt.algorithms.Algorithm;
import shadow.palantir.driver.com.auth0.jwt.algorithms.CryptoHelper;
import shadow.palantir.driver.com.auth0.jwt.exceptions.SignatureGenerationException;
import shadow.palantir.driver.com.auth0.jwt.exceptions.SignatureVerificationException;
import shadow.palantir.driver.com.auth0.jwt.interfaces.DecodedJWT;

class HMACAlgorithm
extends Algorithm {
    private final CryptoHelper crypto;
    private final byte[] secret;

    HMACAlgorithm(CryptoHelper crypto, String id, String algorithm, byte[] secretBytes) throws IllegalArgumentException {
        super(id, algorithm);
        if (secretBytes == null) {
            throw new IllegalArgumentException("The Secret cannot be null");
        }
        this.secret = Arrays.copyOf(secretBytes, secretBytes.length);
        this.crypto = crypto;
    }

    HMACAlgorithm(String id, String algorithm, byte[] secretBytes) throws IllegalArgumentException {
        this(new CryptoHelper(), id, algorithm, secretBytes);
    }

    HMACAlgorithm(String id, String algorithm, String secret) throws IllegalArgumentException {
        this(new CryptoHelper(), id, algorithm, HMACAlgorithm.getSecretBytes(secret));
    }

    static byte[] getSecretBytes(String secret) throws IllegalArgumentException {
        if (secret == null) {
            throw new IllegalArgumentException("The Secret cannot be null");
        }
        return secret.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void verify(DecodedJWT jwt) throws SignatureVerificationException {
        try {
            byte[] signatureBytes = Base64.getUrlDecoder().decode(jwt.getSignature());
            boolean valid = this.crypto.verifySignatureFor(this.getDescription(), this.secret, jwt.getHeader(), jwt.getPayload(), signatureBytes);
            if (!valid) {
                throw new SignatureVerificationException(this);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] headerBytes, byte[] payloadBytes) throws SignatureGenerationException {
        try {
            return this.crypto.createSignatureFor(this.getDescription(), this.secret, headerBytes, payloadBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SignatureGenerationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] contentBytes) throws SignatureGenerationException {
        try {
            return this.crypto.createSignatureFor(this.getDescription(), this.secret, contentBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SignatureGenerationException(this, (Throwable)e);
        }
    }
}

