/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.auth0.jwt.algorithms;

import java.util.Base64;
import shadow.palantir.driver.com.auth0.jwt.algorithms.Algorithm;
import shadow.palantir.driver.com.auth0.jwt.exceptions.SignatureGenerationException;
import shadow.palantir.driver.com.auth0.jwt.exceptions.SignatureVerificationException;
import shadow.palantir.driver.com.auth0.jwt.interfaces.DecodedJWT;

class NoneAlgorithm
extends Algorithm {
    NoneAlgorithm() {
        super("none", "none");
    }

    @Override
    public void verify(DecodedJWT jwt) throws SignatureVerificationException {
        try {
            byte[] signatureBytes = Base64.getUrlDecoder().decode(jwt.getSignature());
            if (signatureBytes.length > 0) {
                throw new SignatureVerificationException(this);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] headerBytes, byte[] payloadBytes) throws SignatureGenerationException {
        return new byte[0];
    }

    @Override
    public byte[] sign(byte[] contentBytes) throws SignatureGenerationException {
        return new byte[0];
    }
}

