/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.auth0.jwt.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import shadow.palantir.driver.com.auth0.jwt.impl.JsonNodeClaim;
import shadow.palantir.driver.com.auth0.jwt.interfaces.Claim;
import shadow.palantir.driver.com.auth0.jwt.interfaces.Header;
import shadow.palantir.driver.com.fasterxml.jackson.core.ObjectCodec;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonNode;

class BasicHeader
implements Header,
Serializable {
    private static final long serialVersionUID = -4659137688548605095L;
    private final String algorithm;
    private final String type;
    private final String contentType;
    private final String keyId;
    private final Map<String, JsonNode> tree;
    private final ObjectCodec objectCodec;

    BasicHeader(String algorithm, String type, String contentType, String keyId, Map<String, JsonNode> tree, ObjectCodec objectCodec) {
        this.algorithm = algorithm;
        this.type = type;
        this.contentType = contentType;
        this.keyId = keyId;
        this.tree = tree == null ? Collections.emptyMap() : Collections.unmodifiableMap(tree);
        this.objectCodec = objectCodec;
    }

    Map<String, JsonNode> getTree() {
        return this.tree;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    @Override
    public Claim getHeaderClaim(String name) {
        return JsonNodeClaim.extractClaim(name, this.tree, this.objectCodec);
    }
}

