/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.auth0.jwt.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import shadow.palantir.driver.com.auth0.jwt.impl.ClaimsHolder;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonGenerator;
import shadow.palantir.driver.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class ClaimsSerializer<T extends ClaimsHolder>
extends StdSerializer<T> {
    public ClaimsSerializer(Class<T> t) {
        super(t);
    }

    @Override
    public void serialize(T holder, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<String, Object> entry : ((ClaimsHolder)holder).getClaims().entrySet()) {
            this.writeClaim(entry, gen);
        }
        gen.writeEndObject();
    }

    protected void writeClaim(Map.Entry<String, Object> entry, JsonGenerator gen) throws IOException {
        gen.writeFieldName(entry.getKey());
        ClaimsSerializer.handleSerialization(entry.getValue(), gen);
    }

    private static void handleSerialization(Object value, JsonGenerator gen) throws IOException {
        if (value instanceof Date) {
            gen.writeNumber(ClaimsSerializer.dateToSeconds((Date)value));
        } else if (value instanceof Instant) {
            gen.writeNumber(ClaimsSerializer.instantToSeconds((Instant)value));
        } else if (value instanceof Map) {
            ClaimsSerializer.serializeMap((Map)value, gen);
        } else if (value instanceof List) {
            ClaimsSerializer.serializeList((List)value, gen);
        } else {
            gen.writeObject(value);
        }
    }

    private static void serializeMap(Map<?, ?> map, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            gen.writeFieldName((String)entry.getKey());
            Object value = entry.getValue();
            ClaimsSerializer.handleSerialization(value, gen);
        }
        gen.writeEndObject();
    }

    private static void serializeList(List<?> list, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        for (Object entry : list) {
            ClaimsSerializer.handleSerialization(entry, gen);
        }
        gen.writeEndArray();
    }

    private static long instantToSeconds(Instant instant) {
        return instant.getEpochSecond();
    }

    private static long dateToSeconds(Date date) {
        return date.getTime() / 1000L;
    }
}

