/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.auth0.jwt.impl;

import java.io.IOException;
import shadow.palantir.driver.com.auth0.jwt.exceptions.JWTDecodeException;
import shadow.palantir.driver.com.auth0.jwt.impl.HeaderDeserializer;
import shadow.palantir.driver.com.auth0.jwt.impl.PayloadDeserializer;
import shadow.palantir.driver.com.auth0.jwt.interfaces.Header;
import shadow.palantir.driver.com.auth0.jwt.interfaces.JWTPartsParser;
import shadow.palantir.driver.com.auth0.jwt.interfaces.Payload;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.palantir.driver.com.fasterxml.jackson.databind.ObjectReader;
import shadow.palantir.driver.com.fasterxml.jackson.databind.SerializationFeature;
import shadow.palantir.driver.com.fasterxml.jackson.databind.module.SimpleModule;

public class JWTParser
implements JWTPartsParser {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = JWTParser.createDefaultObjectMapper();
    private static final ObjectReader DEFAULT_PAYLOAD_READER = DEFAULT_OBJECT_MAPPER.readerFor(Payload.class);
    private static final ObjectReader DEFAULT_HEADER_READER = DEFAULT_OBJECT_MAPPER.readerFor(Header.class);
    private final ObjectReader payloadReader;
    private final ObjectReader headerReader;

    public JWTParser() {
        this.payloadReader = DEFAULT_PAYLOAD_READER;
        this.headerReader = DEFAULT_HEADER_READER;
    }

    JWTParser(ObjectMapper mapper) {
        JWTParser.addDeserializers(mapper);
        this.payloadReader = mapper.readerFor(Payload.class);
        this.headerReader = mapper.readerFor(Header.class);
    }

    @Override
    public Payload parsePayload(String json) throws JWTDecodeException {
        if (json == null) {
            throw JWTParser.decodeException();
        }
        try {
            return (Payload)this.payloadReader.readValue(json);
        }
        catch (IOException e) {
            throw JWTParser.decodeException(json);
        }
    }

    @Override
    public Header parseHeader(String json) throws JWTDecodeException {
        if (json == null) {
            throw JWTParser.decodeException();
        }
        try {
            return (Header)this.headerReader.readValue(json);
        }
        catch (IOException e) {
            throw JWTParser.decodeException(json);
        }
    }

    static void addDeserializers(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Payload.class, new PayloadDeserializer());
        module.addDeserializer(Header.class, new HeaderDeserializer());
        mapper.registerModule(module);
    }

    static ObjectMapper getDefaultObjectMapper() {
        return DEFAULT_OBJECT_MAPPER;
    }

    private static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        JWTParser.addDeserializers(mapper);
        return mapper;
    }

    private static JWTDecodeException decodeException() {
        return JWTParser.decodeException(null);
    }

    private static JWTDecodeException decodeException(String json) {
        return new JWTDecodeException(String.format("The string '%s' doesn't have a valid JSON format.", json));
    }
}

