/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.auth0.jwt.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import shadow.palantir.driver.com.auth0.jwt.exceptions.JWTDecodeException;
import shadow.palantir.driver.com.auth0.jwt.impl.PayloadImpl;
import shadow.palantir.driver.com.auth0.jwt.interfaces.Payload;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonProcessingException;
import shadow.palantir.driver.com.fasterxml.jackson.core.ObjectCodec;
import shadow.palantir.driver.com.fasterxml.jackson.core.type.TypeReference;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonNode;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.std.StdDeserializer;

class PayloadDeserializer
extends StdDeserializer<Payload> {
    PayloadDeserializer() {
        super(Payload.class);
    }

    @Override
    public Payload deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Map<String, JsonNode> tree = p.getCodec().readValue(p, new TypeReference<Map<String, JsonNode>>(){});
        if (tree == null) {
            throw new JWTDecodeException("Parsing the Payload's JSON resulted on a Null map");
        }
        String issuer = this.getString(tree, "iss");
        String subject = this.getString(tree, "sub");
        List<String> audience = this.getStringOrArray(p.getCodec(), tree, "aud");
        Instant expiresAt = this.getInstantFromSeconds(tree, "exp");
        Instant notBefore = this.getInstantFromSeconds(tree, "nbf");
        Instant issuedAt = this.getInstantFromSeconds(tree, "iat");
        String jwtId = this.getString(tree, "jti");
        return new PayloadImpl(issuer, subject, audience, expiresAt, notBefore, issuedAt, jwtId, tree, p.getCodec());
    }

    List<String> getStringOrArray(ObjectCodec codec, Map<String, JsonNode> tree, String claimName) throws JWTDecodeException {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull() || !node.isArray() && !node.isTextual()) {
            return null;
        }
        if (node.isTextual()) {
            return Collections.singletonList(node.asText());
        }
        ArrayList<String> list = new ArrayList<String>(node.size());
        for (int i = 0; i < node.size(); ++i) {
            try {
                list.add(codec.treeToValue(node.get(i), String.class));
                continue;
            }
            catch (JsonProcessingException e) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to String", e);
            }
        }
        return list;
    }

    Instant getInstantFromSeconds(Map<String, JsonNode> tree, String claimName) {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull()) {
            return null;
        }
        if (!node.canConvertToLong()) {
            throw new JWTDecodeException(String.format("The claim '%s' contained a non-numeric date value.", claimName));
        }
        return Instant.ofEpochSecond(node.asLong());
    }

    String getString(Map<String, JsonNode> tree, String claimName) {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull()) {
            return null;
        }
        return node.asText(null);
    }
}

