/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonToken;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationConfig;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JavaType;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.NullValueProvider;
import shadow.palantir.driver.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.util.AccessPattern;
import shadow.palantir.driver.com.fasterxml.jackson.databind.util.ClassUtil;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.guava.deser.GuavaCollectionDeserializer;
import shadow.palantir.driver.com.google.common.collect.ImmutableCollection;

abstract class GuavaImmutableCollectionDeserializer<T extends ImmutableCollection<Object>>
extends GuavaCollectionDeserializer<T> {
    private static final long serialVersionUID = 1L;

    GuavaImmutableCollectionDeserializer(JavaType selfType, JsonDeserializer<?> deser, TypeDeserializer typeDeser, NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    protected abstract ImmutableCollection.Builder<Object> createBuilder();

    @Override
    public Boolean supportsUpdate(DeserializationConfig config) {
        return Boolean.FALSE;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public T getEmptyValue(DeserializationContext ctxt) {
        return (T)((ImmutableCollection)this._createEmpty(ctxt));
    }

    @Override
    protected T _deserializeContents(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t;
        JsonDeserializer valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        ImmutableCollection.Builder<Object> builder = this.createBuilder();
        while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
            Object value;
            if (t == JsonToken.VALUE_NULL) {
                if (this._skipNullValues) continue;
                value = this._resolveNullToValue(ctxt);
            } else {
                value = typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser);
            }
            if (value == null) {
                this._tryToAddNull(p, ctxt, builder);
                continue;
            }
            builder.add(value);
        }
        ImmutableCollection<Object> collection = builder.build();
        return (T)collection;
    }

    protected Object _resolveNullToValue(DeserializationContext ctxt) throws IOException {
        Object value = this._nullProvider.getNullValue(ctxt);
        return value;
    }

    @Override
    protected void _tryToAddNull(JsonParser p, DeserializationContext ctxt, ImmutableCollection.Builder<Object> builder) throws IOException {
        try {
            builder.add((Object)null);
        }
        catch (NullPointerException e) {
            ctxt.handleUnexpectedToken(this._valueType, JsonToken.VALUE_NULL, p, "Guava `Collection` of type %s does not accept `null` values", ClassUtil.getTypeDescription(this.getValueType(ctxt)));
        }
    }
}

