/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import java.util.Collection;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonToken;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JavaType;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.NullValueProvider;
import shadow.palantir.driver.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.util.AccessPattern;
import shadow.palantir.driver.com.fasterxml.jackson.datatype.guava.deser.GuavaCollectionDeserializer;
import shadow.palantir.driver.com.google.common.collect.Multiset;

abstract class GuavaMultisetDeserializer<T extends Multiset<Object>>
extends GuavaCollectionDeserializer<T> {
    private static final long serialVersionUID = 1L;

    GuavaMultisetDeserializer(JavaType selfType, JsonDeserializer<?> deser, TypeDeserializer typeDeser, NullValueProvider nuller, Boolean unwrapSingle) {
        super(selfType, deser, typeDeser, nuller, unwrapSingle);
    }

    protected abstract T createMultiset();

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public T getEmptyValue(DeserializationContext ctxt) {
        return (T)this._createEmpty(ctxt);
    }

    @Override
    protected T _deserializeContents(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t;
        JsonDeserializer valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        T set = this.createMultiset();
        while ((t = p.nextToken()) != JsonToken.END_ARRAY) {
            Object value;
            if (t == JsonToken.VALUE_NULL) {
                if (this._skipNullValues) continue;
                value = this._nullProvider.getNullValue(ctxt);
                if (value == null) {
                    this._tryToAddNull(p, ctxt, (Collection<?>)set);
                    continue;
                }
            } else {
                value = typeDeser == null ? valueDes.deserialize(p, ctxt) : valueDes.deserializeWithType(p, ctxt, typeDeser);
            }
            set.add(value);
        }
        return set;
    }

    @Override
    protected T _createEmpty(DeserializationContext ctxt) {
        return this.createMultiset();
    }

    @Override
    protected T _createWithSingleElement(DeserializationContext ctxt, Object value) {
        T result = this.createMultiset();
        result.add((Object)value);
        return result;
    }
}

