/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.fasterxml.jackson.datatype.guava.deser;

import java.io.IOException;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonToken;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JsonNode;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import shadow.palantir.driver.com.google.common.net.HostAndPort;

public class HostAndPortDeserializer
extends FromStringDeserializer<HostAndPort> {
    private static final long serialVersionUID = 1L;
    public static final HostAndPortDeserializer std = new HostAndPortDeserializer();

    public HostAndPortDeserializer() {
        super(HostAndPort.class);
    }

    @Override
    public HostAndPort deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.START_OBJECT)) {
            JsonNode root = (JsonNode)p.readValueAsTree();
            JsonNode hostNode = root.get("host");
            if (hostNode == null) {
                hostNode = root.get("hostText");
            }
            String host = hostNode == null || hostNode.isNull() ? "" : hostNode.asText();
            JsonNode n = root.get("port");
            if (n == null) {
                return HostAndPort.fromString(host);
            }
            return HostAndPort.fromParts(host, n.asInt());
        }
        return (HostAndPort)super.deserialize(p, ctxt);
    }

    @Override
    protected HostAndPort _deserialize(String value, DeserializationContext ctxt) throws IOException {
        return HostAndPort.fromString(value);
    }
}

