/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.fasterxml.jackson.datatype.joda.deser;

import java.io.IOException;
import shadow.palantir.driver.com.fasterxml.jackson.core.JsonParser;
import shadow.palantir.driver.com.fasterxml.jackson.core.io.NumberInput;
import shadow.palantir.driver.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.palantir.driver.com.fasterxml.jackson.databind.JavaType;
import shadow.palantir.driver.com.fasterxml.jackson.databind.cfg.CoercionAction;
import shadow.palantir.driver.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import shadow.palantir.driver.com.fasterxml.jackson.databind.type.LogicalType;
import shadow.palantir.driver.com.fasterxml.jackson.databind.util.ClassUtil;

abstract class JodaDeserializerBase<T>
extends StdScalarDeserializer<T> {
    protected JodaDeserializerBase(Class<?> cls) {
        super(cls);
    }

    protected JodaDeserializerBase(JodaDeserializerBase<?> src) {
        super((StdScalarDeserializer<?>)src);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.DateTime;
    }

    protected boolean _isValidTimestampString(String str) {
        return this._isIntNumber(str) && NumberInput.inLongRange(str, str.charAt(0) == '-');
    }

    protected T _fromEmptyString(JsonParser p, DeserializationContext ctxt, String str) throws IOException {
        CoercionAction act = this._checkFromStringCoercion(ctxt, str);
        switch (act) {
            case AsEmpty: {
                return (T)this.getEmptyValue(ctxt);
            }
        }
        return null;
    }

    public T _handleNotNumberOrString(JsonParser p, DeserializationContext ctxt) throws IOException {
        JavaType type = this.getValueType(ctxt);
        return (T)ctxt.handleUnexpectedToken(type, p.currentToken(), p, String.format("Cannot deserialize value of type %s from `JsonToken.%s`: expected Number or String", new Object[]{ClassUtil.getTypeDescription(type), p.currentToken()}), new Object[0]);
    }
}

