/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.github.benmanes.caffeine.cache;

import shadow.palantir.driver.com.github.benmanes.caffeine.cache.AccessOrderDeque;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Caffeine;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Expiry;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.LocalCacheFactory;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Node;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Pacer;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Scheduler;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.Ticker;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.TimerWheel;
import shadow.palantir.driver.com.github.benmanes.caffeine.cache.WSLS;

class WSLSA<K, V>
extends WSLS<K, V> {
    static final LocalCacheFactory FACTORY = WSLSA::new;
    final Ticker ticker;
    final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    WSLSA(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.accessOrderWindowDeque = caffeine.evicts() || caffeine.expiresAfterAccess() ? new AccessOrderDeque() : null;
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel() : null;
        this.expiresAfterAccessNanos = caffeine.getExpiresAfterAccessNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque() {
        return this.accessOrderWindowDeque;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    public final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        this.expiresAfterAccessNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

