/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.google.common.base;

import java.io.Serializable;
import shadow.palantir.driver.com.google.common.annotations.GwtCompatible;
import shadow.palantir.driver.com.google.common.annotations.GwtIncompatible;
import shadow.palantir.driver.com.google.common.annotations.J2ktIncompatible;
import shadow.palantir.driver.com.google.common.base.Equivalence;
import shadow.palantir.driver.com.google.common.base.Function;
import shadow.palantir.driver.com.google.common.base.Objects;
import shadow.palantir.driver.com.google.common.base.Preconditions;
import shadow.palantir.driver.org.jspecify.annotations.Nullable;

@GwtCompatible
final class FunctionalEquivalence<F, T>
extends Equivalence<F>
implements Serializable {
    @GwtIncompatible
    @J2ktIncompatible
    private static final long serialVersionUID = 0L;
    private final Function<? super F, ? extends @Nullable T> function;
    private final Equivalence<T> resultEquivalence;

    FunctionalEquivalence(Function<? super F, ? extends @Nullable T> function, Equivalence<T> resultEquivalence) {
        this.function = Preconditions.checkNotNull(function);
        this.resultEquivalence = Preconditions.checkNotNull(resultEquivalence);
    }

    @Override
    protected boolean doEquivalent(F a, F b) {
        return this.resultEquivalence.equivalent(this.function.apply(a), this.function.apply(b));
    }

    @Override
    protected int doHash(F a) {
        return this.resultEquivalence.hash(this.function.apply(a));
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FunctionalEquivalence) {
            FunctionalEquivalence that = (FunctionalEquivalence)obj;
            return this.function.equals(that.function) && this.resultEquivalence.equals(that.resultEquivalence);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.function, this.resultEquivalence);
    }

    public String toString() {
        return this.resultEquivalence + ".onResultOf(" + this.function + ")";
    }
}

