/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.google.common.util.concurrent;

import java.util.logging.Logger;
import shadow.palantir.driver.com.google.common.annotations.GwtCompatible;
import shadow.palantir.driver.org.jspecify.annotations.Nullable;

@GwtCompatible
final class LazyLogger {
    private final Object lock = new Object();
    private final String loggerName;
    private volatile @Nullable Logger logger;

    LazyLogger(Class<?> ownerOfLogger) {
        this.loggerName = ownerOfLogger.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logger get() {
        Logger local = this.logger;
        if (local != null) {
            return local;
        }
        Object object = this.lock;
        synchronized (object) {
            local = this.logger;
            if (local != null) {
                return local;
            }
            this.logger = Logger.getLogger(this.loggerName);
            return this.logger;
        }
    }
}

