/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.bellaso.api;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonValue;
import shadow.palantir.driver.com.google.errorprone.annotations.Immutable;
import shadow.palantir.driver.javax.annotation.Nonnull;
import shadow.palantir.driver.javax.annotation.Nullable;

@Safe
@Immutable
public final class RequestType {
    public static final RequestType ENCRYPT = new RequestType(Value.ENCRYPT, "ENCRYPT");
    public static final RequestType DECRYPT = new RequestType(Value.DECRYPT, "DECRYPT");
    private static final List<RequestType> values = Collections.unmodifiableList(Arrays.asList(ENCRYPT, DECRYPT));
    private final Value value;
    private final String string;

    private RequestType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value get() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.value == Value.UNKNOWN && other instanceof RequestType && this.string.equals(((RequestType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static RequestType valueOf(@Nonnull @Safe String value) {
        String upperCasedValue;
        Preconditions.checkNotNull(value, "value cannot be null");
        switch (upperCasedValue = value.toUpperCase(Locale.ROOT)) {
            case "ENCRYPT": {
                return ENCRYPT;
            }
            case "DECRYPT": {
                return DECRYPT;
            }
        }
        return new RequestType(Value.UNKNOWN, upperCasedValue);
    }

    public <T> T accept(Visitor<T> visitor) {
        switch (this.value) {
            case ENCRYPT: {
                return visitor.visitEncrypt();
            }
            case DECRYPT: {
                return visitor.visitDecrypt();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    public static List<RequestType> values() {
        return values;
    }

    public static interface Visitor<T> {
        public T visitEncrypt();

        public T visitDecrypt();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        ENCRYPT,
        DECRYPT,
        UNKNOWN;

    }
}

