/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.api.config.service;

import java.util.Objects;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.BasicCredentials;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.ProxyConfiguration;
import shadow.palantir.driver.org.immutables.value.Generated;

@Generated(from="ProxyConfiguration", generator="Immutables")
final class ImmutableProxyConfiguration
extends ProxyConfiguration {
    private final String hostAndPort;
    private final BasicCredentials credentials;
    private final ProxyConfiguration.Type type;

    private ImmutableProxyConfiguration(Builder builder) {
        this.hostAndPort = builder.hostAndPort;
        this.credentials = builder.credentials;
        this.type = builder.type != null ? builder.type : Objects.requireNonNull(super.type(), "type");
    }

    private ImmutableProxyConfiguration(String hostAndPort, BasicCredentials credentials, ProxyConfiguration.Type type) {
        this.hostAndPort = hostAndPort;
        this.credentials = credentials;
        this.type = type;
    }

    @Override
    @JsonProperty(value="hostAndPort")
    @JsonAlias(value={"host-and-port"})
    public Optional<String> hostAndPort() {
        return Optional.ofNullable(this.hostAndPort);
    }

    @Override
    @JsonProperty(value="credentials")
    public Optional<BasicCredentials> credentials() {
        return Optional.ofNullable(this.credentials);
    }

    @Override
    @JsonProperty(value="type")
    public ProxyConfiguration.Type type() {
        return this.type;
    }

    public final ImmutableProxyConfiguration withHostAndPort(String value) {
        String newValue = Objects.requireNonNull(value, "hostAndPort");
        if (Objects.equals(this.hostAndPort, newValue)) {
            return this;
        }
        return ImmutableProxyConfiguration.validate(new ImmutableProxyConfiguration(newValue, this.credentials, this.type));
    }

    public final ImmutableProxyConfiguration withHostAndPort(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hostAndPort, value)) {
            return this;
        }
        return ImmutableProxyConfiguration.validate(new ImmutableProxyConfiguration(value, this.credentials, this.type));
    }

    public final ImmutableProxyConfiguration withCredentials(BasicCredentials value) {
        BasicCredentials newValue = Objects.requireNonNull(value, "credentials");
        if (this.credentials == newValue) {
            return this;
        }
        return ImmutableProxyConfiguration.validate(new ImmutableProxyConfiguration(this.hostAndPort, newValue, this.type));
    }

    public final ImmutableProxyConfiguration withCredentials(Optional<? extends BasicCredentials> optional) {
        BasicCredentials value = optional.orElse(null);
        if (this.credentials == value) {
            return this;
        }
        return ImmutableProxyConfiguration.validate(new ImmutableProxyConfiguration(this.hostAndPort, value, this.type));
    }

    public final ImmutableProxyConfiguration withType(ProxyConfiguration.Type value) {
        ProxyConfiguration.Type newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return ImmutableProxyConfiguration.validate(new ImmutableProxyConfiguration(this.hostAndPort, this.credentials, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProxyConfiguration && this.equalTo(0, (ImmutableProxyConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableProxyConfiguration another) {
        return Objects.equals(this.hostAndPort, another.hostAndPort) && Objects.equals(this.credentials, another.credentials) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.hostAndPort);
        h += (h << 5) + Objects.hashCode(this.credentials);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ProxyConfiguration{");
        if (this.hostAndPort != null) {
            builder.append("hostAndPort=").append(this.hostAndPort);
        }
        if (this.credentials != null) {
            if (builder.length() > 19) {
                builder.append(", ");
            }
            builder.append("credentials=").append(this.credentials);
        }
        if (builder.length() > 19) {
            builder.append(", ");
        }
        builder.append("type=").append((Object)this.type);
        return builder.append("}").toString();
    }

    private static ImmutableProxyConfiguration validate(ImmutableProxyConfiguration instance) {
        instance.check();
        return instance;
    }

    public static ProxyConfiguration copyOf(ProxyConfiguration instance) {
        if (instance instanceof ImmutableProxyConfiguration) {
            return (ImmutableProxyConfiguration)instance;
        }
        return new ProxyConfiguration.Builder().from(instance).build();
    }

    @Generated(from="ProxyConfiguration", generator="Immutables")
    public static class Builder {
        private String hostAndPort;
        private BasicCredentials credentials;
        private ProxyConfiguration.Type type;

        public Builder() {
            if (!(this instanceof ProxyConfiguration.Builder)) {
                throw new UnsupportedOperationException("Use: new ProxyConfiguration.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final ProxyConfiguration.Builder from(ProxyConfiguration instance) {
            Optional<BasicCredentials> credentialsOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> hostAndPortOptional = instance.hostAndPort();
            if (hostAndPortOptional.isPresent()) {
                this.hostAndPort(hostAndPortOptional);
            }
            if ((credentialsOptional = instance.credentials()).isPresent()) {
                this.credentials(credentialsOptional);
            }
            this.type(instance.type());
            return (ProxyConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ProxyConfiguration.Builder hostAndPort(String hostAndPort) {
            this.hostAndPort = Objects.requireNonNull(hostAndPort, "hostAndPort");
            return (ProxyConfiguration.Builder)this;
        }

        @JsonProperty(value="hostAndPort")
        @JsonAlias(value={"host-and-port"})
        @CanIgnoreReturnValue
        public final ProxyConfiguration.Builder hostAndPort(Optional<String> hostAndPort) {
            this.hostAndPort = hostAndPort.orElse(null);
            return (ProxyConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ProxyConfiguration.Builder credentials(BasicCredentials credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
            return (ProxyConfiguration.Builder)this;
        }

        @JsonProperty(value="credentials")
        @CanIgnoreReturnValue
        public final ProxyConfiguration.Builder credentials(Optional<? extends BasicCredentials> credentials) {
            this.credentials = credentials.orElse(null);
            return (ProxyConfiguration.Builder)this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final ProxyConfiguration.Builder type(ProxyConfiguration.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            return (ProxyConfiguration.Builder)this;
        }

        public ProxyConfiguration build() {
            return ImmutableProxyConfiguration.validate(new ImmutableProxyConfiguration(this));
        }
    }
}

