/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.api.config.service;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.DoNotLog;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.palantir.driver.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.BasicCredentials;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.HostAndPort;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.ImmutableProxyConfiguration;
import shadow.palantir.driver.org.immutables.value.Value;

@DoNotLog
@JsonSerialize(as=ImmutableProxyConfiguration.class)
@JsonDeserialize(builder=Builder.class)
@Value.Immutable
public abstract class ProxyConfiguration {
    public static final ProxyConfiguration DIRECT = new Builder().type(Type.DIRECT).build();

    @JsonProperty(value="hostAndPort")
    @JsonAlias(value={"host-and-port"})
    public abstract Optional<String> hostAndPort();

    public abstract Optional<BasicCredentials> credentials();

    @JsonProperty(value="type")
    @Value.Default
    public Type type() {
        return Type.HTTP;
    }

    @Value.Check
    protected final void check() {
        switch (this.type()) {
            case MESH: 
            case HTTP: 
            case HTTPS: {
                Preconditions.checkArgument(this.hostAndPort().isPresent(), "host-and-port must be configured for an HTTP proxy");
                HostAndPort host = HostAndPort.fromString(this.hostAndPort().get());
                Preconditions.checkArgument(host.hasPort(), "Given hostname does not contain a port number", SafeArg.of("hostname", host));
                break;
            }
            case DIRECT: {
                Preconditions.checkArgument(this.hostAndPort().isEmpty() && this.credentials().isEmpty(), "Neither credential nor host-and-port may be configured for DIRECT proxies");
                break;
            }
            case FROM_ENVIRONMENT: {
                Preconditions.checkArgument(this.hostAndPort().isEmpty(), "Host-and-port may not be configured for FROM_ENVIRONMENT proxies");
                break;
            }
            case SOCKS: {
                Preconditions.checkArgument(this.hostAndPort().isPresent(), "host-and-port must be configured for a SOCKS proxy");
                HostAndPort socksHostAndPort = HostAndPort.fromString(this.hostAndPort().get());
                Preconditions.checkArgument(socksHostAndPort.hasPort(), "Given hostname does not contain a port number", SafeArg.of("hostname", socksHostAndPort));
                break;
            }
            default: {
                throw new SafeIllegalStateException("Unrecognized case; this is a library bug", new Arg[0]);
            }
        }
        if (this.credentials().isPresent()) {
            Preconditions.checkArgument(this.type() == Type.HTTP || this.type() == Type.HTTPS, "credentials are only valid for HTTP or HTTPS proxies");
        }
    }

    public static ProxyConfiguration of(String hostAndPort) {
        return ProxyConfiguration.builder().hostAndPort(hostAndPort).build();
    }

    public static ProxyConfiguration of(String hostAndPort, BasicCredentials credentials) {
        return ProxyConfiguration.builder().hostAndPort(hostAndPort).credentials(credentials).build();
    }

    public static ProxyConfiguration mesh(String hostAndPort) {
        return ProxyConfiguration.builder().type(Type.MESH).hostAndPort(hostAndPort).build();
    }

    public static ProxyConfiguration socks(String hostAndPort) {
        return ProxyConfiguration.builder().type(Type.SOCKS).hostAndPort(hostAndPort).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableProxyConfiguration.Builder {
    }

    public static enum Type {
        DIRECT,
        FROM_ENVIRONMENT,
        HTTP,
        HTTPS,
        MESH,
        SOCKS;

    }
}

