/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.api.config.service;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.ImmutableAgent;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.ImmutableUserAgent;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.UserAgents;
import shadow.palantir.driver.org.immutables.value.Value;

@Value.Immutable
public interface UserAgent {
    public Optional<String> nodeId();

    public Agent primary();

    public List<Agent> informational();

    public static UserAgent of(Agent agent, String nodeId) {
        return ImmutableUserAgent.builder().nodeId(nodeId).primary(agent).build();
    }

    public static UserAgent of(Agent agent) {
        return ImmutableUserAgent.builder().primary(agent).build();
    }

    public static UserAgent of(UserAgent base, Iterable<Agent> additional) {
        return ImmutableUserAgent.builder().from(base).addAllInformational(additional).build();
    }

    default public UserAgent addAgent(Agent agent) {
        return ImmutableUserAgent.builder().from(this).addInformational(agent).build();
    }

    @Value.Check
    default public void check() {
        if (this.nodeId().isPresent()) {
            Preconditions.checkArgument(UserAgents.isValidNodeId(this.nodeId().get()), "Illegal node id format", SafeArg.of("nodeId", this.nodeId().get()));
        }
    }

    @Value.Immutable
    public static interface Agent {
        public static final String DEFAULT_VERSION = "0.0.0";

        public String name();

        public String version();

        @Value.Check
        default public void check() {
            if (!UserAgents.isValidName(this.name())) {
                throw new SafeIllegalArgumentException("Illegal agent name format", SafeArg.of("name", this.name()));
            }
            if (!UserAgents.isValidVersion(this.version())) {
                throw new SafeIllegalArgumentException("Illegal version format. This is a bug", SafeArg.of("version", this.version()));
            }
        }

        public static Agent of(String name, String version) {
            return ImmutableAgent.builder().name(name).version(UserAgents.isValidVersion(version) ? version : DEFAULT_VERSION).build();
        }
    }
}

