/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.api.config.service;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.ImmutableUserAgent;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.UserAgent;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.VersionParser;

public final class UserAgents {
    public static final String CONJURE_AGENT_NAME = "conjure-java-runtime";
    private static final SafeLogger log = SafeLoggerFactory.get(UserAgents.class);
    static final Pattern NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9\\-]*");
    private static final Pattern LENIENT_VERSION_REGEX = Pattern.compile("[0-9a-z.-]+");
    private static final Pattern NODE_REGEX = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9.\\-]*");
    private static final Pattern VERSION_REGEX = Pattern.compile("^[0-9]+(\\.[0-9]+)*(-rc[0-9]+)?(-[0-9]+-g[a-f0-9]+)?$");
    private static final Pattern SEGMENT_PATTERN = Pattern.compile(String.format("(%s)/(%s)( \\((.+?)\\))?", NAME_REGEX, LENIENT_VERSION_REGEX));

    private UserAgents() {
    }

    public static String format(UserAgent userAgent) {
        StringBuilder formatted = new StringBuilder(64);
        UserAgents.formatSimpleAgent(userAgent.primary(), formatted);
        if (userAgent.nodeId().isPresent()) {
            formatted.append(" (nodeId:").append(userAgent.nodeId().get()).append(')');
        }
        for (UserAgent.Agent informationalAgent : userAgent.informational()) {
            formatted.append(' ');
            UserAgents.formatSimpleAgent(informationalAgent, formatted);
        }
        return formatted.toString();
    }

    private static void formatSimpleAgent(UserAgent.Agent agent, StringBuilder output) {
        output.ensureCapacity(output.length() + 1 + agent.name().length() + agent.version().length());
        output.append(agent.name()).append('/').append(agent.version());
    }

    public static UserAgent parse(String userAgent) {
        Preconditions.checkNotNull(userAgent, "userAgent must not be null");
        return UserAgents.parseInternal(userAgent, false);
    }

    public static UserAgent tryParse(String userAgent) {
        return UserAgents.parseInternal(userAgent == null ? "" : userAgent, true);
    }

    private static UserAgent parseInternal(String userAgent, boolean lenient) {
        ImmutableUserAgent.Builder builder = ImmutableUserAgent.builder();
        Matcher matcher = SEGMENT_PATTERN.matcher(userAgent);
        boolean foundFirst = false;
        while (matcher.find()) {
            String name = matcher.group(1);
            String version = matcher.group(2);
            Optional<String> comments = Optional.ofNullable(matcher.group(4));
            if (!foundFirst) {
                builder.primary(UserAgent.Agent.of(name, version));
                comments.ifPresent(c -> {
                    Map<String, String> parsedComments = UserAgents.parseComments(c);
                    if (parsedComments.containsKey("nodeId")) {
                        builder.nodeId(parsedComments.get("nodeId"));
                    }
                });
            } else {
                builder.addInformational(UserAgent.Agent.of(name, version));
            }
            foundFirst = true;
        }
        if (!foundFirst) {
            if (lenient) {
                if (log.isDebugEnabled()) {
                    log.debug("Invalid user agent '{}', falling back to default/unknown agent", SafeArg.of("userAgent", userAgent));
                }
                return builder.primary(UserAgent.Agent.of("unknown", "0.0.0")).build();
            }
            throw new SafeIllegalArgumentException("Failed to parse user agent string", SafeArg.of("userAgent", userAgent));
        }
        return builder.build();
    }

    private static Map<String, String> parseComments(String commentsString) {
        HashMap<String, String> comments = new HashMap<String, String>();
        for (String comment : commentsString.split("[,;]")) {
            String[] fields = comment.split(":");
            if (fields.length == 2) {
                comments.put(fields[0], fields[1]);
                continue;
            }
            comments.put(comment, comment);
        }
        return comments;
    }

    static boolean isValidName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        char ch = name.charAt(0);
        if (!UserAgents.isAlpha(ch)) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            ch = name.charAt(i);
            if (UserAgents.isAlpha(ch) || UserAgents.isNumeric(ch) || ch == '-') continue;
            return false;
        }
        return true;
    }

    private static boolean isAlpha(char ch) {
        return 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z';
    }

    private static boolean isNumeric(char ch) {
        return '0' <= ch && ch <= '9';
    }

    static boolean isValidNodeId(String instanceId) {
        return NODE_REGEX.matcher(instanceId).matches();
    }

    static boolean isValidVersion(String version) {
        if (VersionParser.countNumericDotGroups(version) >= 2 || UserAgents.versionMatchesRegex(version)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Encountered invalid user agent version '{}'", SafeArg.of("version", version));
        }
        return false;
    }

    static boolean versionMatchesRegex(String version) {
        return VERSION_REGEX.matcher(version).matches();
    }
}

