/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.api.config.ssl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.palantir.driver.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SslConfiguration", generator="Immutables")
@Immutable
final class ImmutableSslConfiguration
extends SslConfiguration {
    private final Path trustStorePath;
    private final SslConfiguration.StoreType trustStoreType;
    @Nullable
    private final Path keyStorePath;
    @Nullable
    private final String keyStorePassword;
    private final SslConfiguration.StoreType keyStoreType;
    @Nullable
    private final String keyStoreKeyAlias;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSslConfiguration(Builder builder) {
        this.trustStorePath = builder.trustStorePath;
        this.keyStorePath = builder.keyStorePath;
        this.keyStorePassword = builder.keyStorePassword;
        this.keyStoreKeyAlias = builder.keyStoreKeyAlias;
        if (builder.trustStoreType != null) {
            this.initShim.trustStoreType(builder.trustStoreType);
        }
        if (builder.keyStoreType != null) {
            this.initShim.keyStoreType(builder.keyStoreType);
        }
        this.trustStoreType = this.initShim.trustStoreType();
        this.keyStoreType = this.initShim.keyStoreType();
        this.initShim = null;
    }

    private ImmutableSslConfiguration(Path trustStorePath, SslConfiguration.StoreType trustStoreType, @Nullable Path keyStorePath, @Nullable String keyStorePassword, SslConfiguration.StoreType keyStoreType, @Nullable String keyStoreKeyAlias) {
        this.trustStorePath = trustStorePath;
        this.trustStoreType = trustStoreType;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.keyStoreKeyAlias = keyStoreKeyAlias;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="trustStorePath")
    @JsonAlias(value={"trust-store-path"})
    public Path trustStorePath() {
        return this.trustStorePath;
    }

    @Override
    @JsonProperty(value="trustStoreType")
    @JsonAlias(value={"trust-store-type"})
    public SslConfiguration.StoreType trustStoreType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.trustStoreType() : this.trustStoreType;
    }

    @Override
    @JsonProperty(value="keyStorePath")
    @JsonAlias(value={"key-store-path"})
    public Optional<Path> keyStorePath() {
        return Optional.ofNullable(this.keyStorePath);
    }

    @Override
    @JsonProperty(value="keyStorePassword")
    @JsonAlias(value={"key-store-password"})
    public Optional<String> keyStorePassword() {
        return Optional.ofNullable(this.keyStorePassword);
    }

    @Override
    @JsonProperty(value="keyStoreType")
    @JsonAlias(value={"key-store-type"})
    public SslConfiguration.StoreType keyStoreType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keyStoreType() : this.keyStoreType;
    }

    @Override
    @JsonProperty(value="keyStoreKeyAlias")
    @JsonAlias(value={"key-store-key-alias"})
    public Optional<String> keyStoreKeyAlias() {
        return Optional.ofNullable(this.keyStoreKeyAlias);
    }

    public final ImmutableSslConfiguration withTrustStorePath(Path value) {
        if (this.trustStorePath == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "trustStorePath");
        return ImmutableSslConfiguration.validate(new ImmutableSslConfiguration(newValue, this.trustStoreType, this.keyStorePath, this.keyStorePassword, this.keyStoreType, this.keyStoreKeyAlias));
    }

    public final ImmutableSslConfiguration withTrustStoreType(SslConfiguration.StoreType value) {
        SslConfiguration.StoreType newValue = Objects.requireNonNull(value, "trustStoreType");
        if (this.trustStoreType == newValue) {
            return this;
        }
        return ImmutableSslConfiguration.validate(new ImmutableSslConfiguration(this.trustStorePath, newValue, this.keyStorePath, this.keyStorePassword, this.keyStoreType, this.keyStoreKeyAlias));
    }

    public final ImmutableSslConfiguration withKeyStorePath(Path value) {
        Path newValue = Objects.requireNonNull(value, "keyStorePath");
        if (this.keyStorePath == newValue) {
            return this;
        }
        return ImmutableSslConfiguration.validate(new ImmutableSslConfiguration(this.trustStorePath, this.trustStoreType, newValue, this.keyStorePassword, this.keyStoreType, this.keyStoreKeyAlias));
    }

    public final ImmutableSslConfiguration withKeyStorePath(Optional<? extends Path> optional) {
        Path value = optional.orElse(null);
        if (this.keyStorePath == value) {
            return this;
        }
        return ImmutableSslConfiguration.validate(new ImmutableSslConfiguration(this.trustStorePath, this.trustStoreType, value, this.keyStorePassword, this.keyStoreType, this.keyStoreKeyAlias));
    }

    public final ImmutableSslConfiguration withKeyStorePassword(String value) {
        String newValue = Objects.requireNonNull(value, "keyStorePassword");
        if (Objects.equals(this.keyStorePassword, newValue)) {
            return this;
        }
        return ImmutableSslConfiguration.validate(new ImmutableSslConfiguration(this.trustStorePath, this.trustStoreType, this.keyStorePath, newValue, this.keyStoreType, this.keyStoreKeyAlias));
    }

    public final ImmutableSslConfiguration withKeyStorePassword(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.keyStorePassword, value)) {
            return this;
        }
        return ImmutableSslConfiguration.validate(new ImmutableSslConfiguration(this.trustStorePath, this.trustStoreType, this.keyStorePath, value, this.keyStoreType, this.keyStoreKeyAlias));
    }

    public final ImmutableSslConfiguration withKeyStoreType(SslConfiguration.StoreType value) {
        SslConfiguration.StoreType newValue = Objects.requireNonNull(value, "keyStoreType");
        if (this.keyStoreType == newValue) {
            return this;
        }
        return ImmutableSslConfiguration.validate(new ImmutableSslConfiguration(this.trustStorePath, this.trustStoreType, this.keyStorePath, this.keyStorePassword, newValue, this.keyStoreKeyAlias));
    }

    public final ImmutableSslConfiguration withKeyStoreKeyAlias(String value) {
        String newValue = Objects.requireNonNull(value, "keyStoreKeyAlias");
        if (Objects.equals(this.keyStoreKeyAlias, newValue)) {
            return this;
        }
        return ImmutableSslConfiguration.validate(new ImmutableSslConfiguration(this.trustStorePath, this.trustStoreType, this.keyStorePath, this.keyStorePassword, this.keyStoreType, newValue));
    }

    public final ImmutableSslConfiguration withKeyStoreKeyAlias(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.keyStoreKeyAlias, value)) {
            return this;
        }
        return ImmutableSslConfiguration.validate(new ImmutableSslConfiguration(this.trustStorePath, this.trustStoreType, this.keyStorePath, this.keyStorePassword, this.keyStoreType, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSslConfiguration && this.equalTo(0, (ImmutableSslConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableSslConfiguration another) {
        return this.trustStorePath.equals(another.trustStorePath) && this.trustStoreType.equals((Object)another.trustStoreType) && Objects.equals(this.keyStorePath, another.keyStorePath) && Objects.equals(this.keyStorePassword, another.keyStorePassword) && this.keyStoreType.equals((Object)another.keyStoreType) && Objects.equals(this.keyStoreKeyAlias, another.keyStoreKeyAlias);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.trustStorePath.hashCode();
        h += (h << 5) + this.trustStoreType.hashCode();
        h += (h << 5) + Objects.hashCode(this.keyStorePath);
        h += (h << 5) + Objects.hashCode(this.keyStorePassword);
        h += (h << 5) + this.keyStoreType.hashCode();
        h += (h << 5) + Objects.hashCode(this.keyStoreKeyAlias);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SslConfiguration{");
        builder.append("trustStorePath=").append(this.trustStorePath);
        builder.append(", ");
        builder.append("trustStoreType=").append((Object)this.trustStoreType);
        if (this.keyStorePath != null) {
            builder.append(", ");
            builder.append("keyStorePath=").append(this.keyStorePath);
        }
        builder.append(", ");
        builder.append("keyStoreType=").append((Object)this.keyStoreType);
        if (this.keyStoreKeyAlias != null) {
            builder.append(", ");
            builder.append("keyStoreKeyAlias=").append(this.keyStoreKeyAlias);
        }
        return builder.append("}").toString();
    }

    private static ImmutableSslConfiguration validate(ImmutableSslConfiguration instance) {
        instance.check();
        return instance;
    }

    public static SslConfiguration copyOf(SslConfiguration instance) {
        if (instance instanceof ImmutableSslConfiguration) {
            return (ImmutableSslConfiguration)instance;
        }
        return new SslConfiguration.Builder().from(instance).build();
    }

    @Generated(from="SslConfiguration", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_TRUST_STORE_PATH = 1L;
        private long initBits = 1L;
        @Nullable
        private Path trustStorePath;
        @Nullable
        private SslConfiguration.StoreType trustStoreType;
        @Nullable
        private Path keyStorePath;
        @Nullable
        private String keyStorePassword;
        @Nullable
        private SslConfiguration.StoreType keyStoreType;
        @Nullable
        private String keyStoreKeyAlias;

        public Builder() {
            if (!(this instanceof SslConfiguration.Builder)) {
                throw new UnsupportedOperationException("Use: new SslConfiguration.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final SslConfiguration.Builder from(SslConfiguration instance) {
            Optional<String> keyStorePasswordOptional;
            Objects.requireNonNull(instance, "instance");
            this.trustStorePath(instance.trustStorePath());
            this.trustStoreType(instance.trustStoreType());
            Optional<Path> keyStorePathOptional = instance.keyStorePath();
            if (keyStorePathOptional.isPresent()) {
                this.keyStorePath(keyStorePathOptional);
            }
            if ((keyStorePasswordOptional = instance.keyStorePassword()).isPresent()) {
                this.keyStorePassword(keyStorePasswordOptional);
            }
            this.keyStoreType(instance.keyStoreType());
            Optional<String> keyStoreKeyAliasOptional = instance.keyStoreKeyAlias();
            if (keyStoreKeyAliasOptional.isPresent()) {
                this.keyStoreKeyAlias(keyStoreKeyAliasOptional);
            }
            return (SslConfiguration.Builder)this;
        }

        @JsonProperty(value="trustStorePath")
        @JsonAlias(value={"trust-store-path"})
        @CanIgnoreReturnValue
        public final SslConfiguration.Builder trustStorePath(Path trustStorePath) {
            this.trustStorePath = Objects.requireNonNull(trustStorePath, "trustStorePath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (SslConfiguration.Builder)this;
        }

        @JsonProperty(value="trustStoreType")
        @JsonAlias(value={"trust-store-type"})
        @CanIgnoreReturnValue
        public final SslConfiguration.Builder trustStoreType(SslConfiguration.StoreType trustStoreType) {
            this.trustStoreType = Objects.requireNonNull(trustStoreType, "trustStoreType");
            return (SslConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SslConfiguration.Builder keyStorePath(Path keyStorePath) {
            this.keyStorePath = Objects.requireNonNull(keyStorePath, "keyStorePath");
            return (SslConfiguration.Builder)this;
        }

        @JsonProperty(value="keyStorePath")
        @JsonAlias(value={"key-store-path"})
        @CanIgnoreReturnValue
        public final SslConfiguration.Builder keyStorePath(Optional<? extends Path> keyStorePath) {
            this.keyStorePath = keyStorePath.orElse(null);
            return (SslConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SslConfiguration.Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = Objects.requireNonNull(keyStorePassword, "keyStorePassword");
            return (SslConfiguration.Builder)this;
        }

        @JsonProperty(value="keyStorePassword")
        @JsonAlias(value={"key-store-password"})
        @CanIgnoreReturnValue
        public final SslConfiguration.Builder keyStorePassword(Optional<String> keyStorePassword) {
            this.keyStorePassword = keyStorePassword.orElse(null);
            return (SslConfiguration.Builder)this;
        }

        @JsonProperty(value="keyStoreType")
        @JsonAlias(value={"key-store-type"})
        @CanIgnoreReturnValue
        public final SslConfiguration.Builder keyStoreType(SslConfiguration.StoreType keyStoreType) {
            this.keyStoreType = Objects.requireNonNull(keyStoreType, "keyStoreType");
            return (SslConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SslConfiguration.Builder keyStoreKeyAlias(String keyStoreKeyAlias) {
            this.keyStoreKeyAlias = Objects.requireNonNull(keyStoreKeyAlias, "keyStoreKeyAlias");
            return (SslConfiguration.Builder)this;
        }

        @JsonProperty(value="keyStoreKeyAlias")
        @JsonAlias(value={"key-store-key-alias"})
        @CanIgnoreReturnValue
        public final SslConfiguration.Builder keyStoreKeyAlias(Optional<String> keyStoreKeyAlias) {
            this.keyStoreKeyAlias = keyStoreKeyAlias.orElse(null);
            return (SslConfiguration.Builder)this;
        }

        public SslConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableSslConfiguration.validate(new ImmutableSslConfiguration(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("trustStorePath");
            }
            return "Cannot build SslConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="SslConfiguration", generator="Immutables")
    private final class InitShim {
        private byte trustStoreTypeBuildStage = 0;
        private SslConfiguration.StoreType trustStoreType;
        private byte keyStoreTypeBuildStage = 0;
        private SslConfiguration.StoreType keyStoreType;

        private InitShim() {
        }

        SslConfiguration.StoreType trustStoreType() {
            if (this.trustStoreTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.trustStoreTypeBuildStage == 0) {
                this.trustStoreTypeBuildStage = (byte)-1;
                this.trustStoreType = Objects.requireNonNull(ImmutableSslConfiguration.super.trustStoreType(), "trustStoreType");
                this.trustStoreTypeBuildStage = 1;
            }
            return this.trustStoreType;
        }

        void trustStoreType(SslConfiguration.StoreType trustStoreType) {
            this.trustStoreType = trustStoreType;
            this.trustStoreTypeBuildStage = 1;
        }

        SslConfiguration.StoreType keyStoreType() {
            if (this.keyStoreTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyStoreTypeBuildStage == 0) {
                this.keyStoreTypeBuildStage = (byte)-1;
                this.keyStoreType = Objects.requireNonNull(ImmutableSslConfiguration.super.keyStoreType(), "keyStoreType");
                this.keyStoreTypeBuildStage = 1;
            }
            return this.keyStoreType;
        }

        void keyStoreType(SslConfiguration.StoreType keyStoreType) {
            this.keyStoreType = keyStoreType;
            this.keyStoreTypeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.trustStoreTypeBuildStage == -1) {
                attributes.add("trustStoreType");
            }
            if (this.keyStoreTypeBuildStage == -1) {
                attributes.add("keyStoreType");
            }
            return "Cannot build SslConfiguration, attribute initializers form cycle " + attributes;
        }
    }
}

