/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.api.errors;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.Unsafe;
import com.palantir.logsafe.UnsafeArg;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shadow.palantir.driver.com.palantir.conjure.java.api.errors.QosReason;

public abstract class QosException
extends RuntimeException {
    private final QosReason reason;

    private QosException(String message, QosReason reason) {
        super(message);
        this.reason = Preconditions.checkNotNull(reason, "QosReason is required");
    }

    private QosException(String message, Throwable cause, QosReason reason) {
        super(message, cause);
        this.reason = Preconditions.checkNotNull(reason, "QosReason is required");
    }

    public final QosReason getReason() {
        return this.reason;
    }

    public abstract <T> T accept(Visitor<T> var1);

    public static Throttle throttle() {
        return new Throttle(Optional.empty());
    }

    public static Throttle throttle(QosReason reason) {
        return new Throttle(Optional.empty(), reason);
    }

    public static Throttle throttle(Throwable cause) {
        return new Throttle(Optional.empty(), cause);
    }

    public static Throttle throttle(QosReason reason, Throwable cause) {
        return new Throttle(Optional.empty(), cause, reason);
    }

    public static Throttle throttle(Duration duration) {
        return new Throttle(Optional.of(duration));
    }

    public static Throttle throttle(QosReason reason, Duration duration) {
        return new Throttle(Optional.of(duration), reason);
    }

    public static Throttle throttle(Duration duration, Throwable cause) {
        return new Throttle(Optional.of(duration), cause);
    }

    public static Throttle throttle(QosReason reason, Duration duration, Throwable cause) {
        return new Throttle(Optional.of(duration), cause, reason);
    }

    public static RetryOther retryOther(URL redirectTo) {
        return new RetryOther(redirectTo);
    }

    public static RetryOther retryOther(QosReason reason, URL redirectTo) {
        return new RetryOther(redirectTo, reason);
    }

    public static RetryOther retryOther(URL redirectTo, Throwable cause) {
        return new RetryOther(redirectTo, cause);
    }

    public static RetryOther retryOther(QosReason reason, URL redirectTo, Throwable cause) {
        return new RetryOther(redirectTo, cause, reason);
    }

    public static Unavailable unavailable() {
        return new Unavailable();
    }

    public static Unavailable unavailable(QosReason reason) {
        return new Unavailable(reason);
    }

    public static Unavailable unavailable(Throwable cause) {
        return new Unavailable(cause);
    }

    public static Unavailable unavailable(QosReason reason, Throwable cause) {
        return new Unavailable(cause, reason);
    }

    public static final class Unavailable
    extends QosException
    implements SafeLoggable {
        private static final QosReason DEFAULT_REASON = QosReason.of("qos-unavailable");
        private static final String SERVER_UNAVAILABLE = "Server unavailable";

        private Unavailable() {
            super(SERVER_UNAVAILABLE, DEFAULT_REASON);
        }

        private Unavailable(QosReason reason) {
            super(SERVER_UNAVAILABLE, reason);
        }

        private Unavailable(Throwable cause) {
            super(SERVER_UNAVAILABLE, cause, DEFAULT_REASON);
        }

        private Unavailable(Throwable cause, QosReason reason) {
            super(SERVER_UNAVAILABLE, cause, reason);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String getLogMessage() {
            return SERVER_UNAVAILABLE;
        }

        @Override
        public List<Arg<?>> getArgs() {
            return Collections.singletonList(SafeArg.of("reason", this.getReason()));
        }
    }

    public static final class RetryOther
    extends QosException
    implements SafeLoggable {
        private static final QosReason DEFAULT_REASON = QosReason.of("qos-retry-other");
        private final URL redirectTo;

        private RetryOther(URL redirectTo) {
            super("Suggesting request retry against: " + redirectTo.toString(), DEFAULT_REASON);
            this.redirectTo = redirectTo;
        }

        private RetryOther(URL redirectTo, QosReason reason) {
            super("Suggesting request retry against: " + redirectTo.toString(), reason);
            this.redirectTo = redirectTo;
        }

        private RetryOther(URL redirectTo, Throwable cause) {
            super("Suggesting request retry against: " + redirectTo.toString(), cause, DEFAULT_REASON);
            this.redirectTo = redirectTo;
        }

        private RetryOther(URL redirectTo, Throwable cause, QosReason reason) {
            super("Suggesting request retry against: " + redirectTo.toString(), cause, reason);
            this.redirectTo = redirectTo;
        }

        public URL getRedirectTo() {
            return this.redirectTo;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String getLogMessage() {
            return this.getClass().getSimpleName() + ": Requesting retry";
        }

        @Override
        @Unsafe
        public List<Arg<?>> getArgs() {
            return List.of(UnsafeArg.of("redirectTo", this.redirectTo), SafeArg.of("reason", this.getReason()));
        }
    }

    public static final class Throttle
    extends QosException
    implements SafeLoggable {
        private static final QosReason DEFAULT_REASON = QosReason.of("qos-throttle");
        private final Optional<Duration> retryAfter;

        private Throttle(Optional<Duration> retryAfter) {
            super("Suggesting request throttling with optional retryAfter duration: " + retryAfter, DEFAULT_REASON);
            this.retryAfter = retryAfter;
        }

        private Throttle(Optional<Duration> retryAfter, QosReason reason) {
            super("Suggesting request throttling with optional retryAfter duration: " + retryAfter, reason);
            this.retryAfter = retryAfter;
        }

        private Throttle(Optional<Duration> retryAfter, Throwable cause) {
            super("Suggesting request throttling with optional retryAfter duration: " + retryAfter, cause, DEFAULT_REASON);
            this.retryAfter = retryAfter;
        }

        private Throttle(Optional<Duration> retryAfter, Throwable cause, QosReason reason) {
            super("Suggesting request throttling with optional retryAfter duration: " + retryAfter, cause, reason);
            this.retryAfter = retryAfter;
        }

        public Optional<Duration> getRetryAfter() {
            return this.retryAfter;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String getLogMessage() {
            return "Suggested request throttling";
        }

        @Override
        public List<Arg<?>> getArgs() {
            return List.of(SafeArg.of("retryAfter", this.retryAfter.orElse(null)), SafeArg.of("reason", this.getReason()));
        }
    }

    public static interface Visitor<T> {
        public T visit(Throttle var1);

        public T visit(RetryOther var1);

        public T visit(Unavailable var1);
    }
}

