/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.api.errors;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import java.util.Objects;
import shadow.palantir.driver.com.google.errorprone.annotations.CompileTimeConstant;
import shadow.palantir.driver.org.intellij.lang.annotations.Pattern;

public final class QosReason {
    @CompileTimeConstant
    private final String reason;
    private static final String PATTERN_STRING = "^[a-z0-9\\-]{1,50}$";
    private static final java.util.regex.Pattern PATTERN = java.util.regex.Pattern.compile("^[a-z0-9\\-]{1,50}$");

    private QosReason(@CompileTimeConstant String reason) {
        this.reason = reason;
    }

    public static QosReason of(@CompileTimeConstant @Pattern(value="^[a-z0-9\\-]{1,50}$") String reason) {
        Preconditions.checkArgument(PATTERN.matcher(reason).matches(), "Reason must be at most 50 characters, and only contain lowercase letters, numbers, and hyphens (-).", SafeArg.of("reason", reason));
        return new QosReason(reason);
    }

    public String toString() {
        return this.reason;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof QosReason)) {
            return false;
        }
        QosReason otherReason = (QosReason)other;
        return Objects.equals(this.reason, otherReason.reason);
    }

    public int hashCode() {
        return Objects.hashCode(this.reason);
    }
}

