/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.client.config;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import shadow.palantir.driver.com.google.common.annotations.VisibleForTesting;
import shadow.palantir.driver.com.google.common.collect.ImmutableList;
import shadow.palantir.driver.com.google.common.net.HostAndPort;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.ProxyConfiguration;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.ServiceConfiguration;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.UserAgent;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.ClientConfiguration;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.HttpsProxies;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.NodeSelectionStrategy;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.SslSocketFactories;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.TrustContext;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.SharedTaggedMetricRegistries;

public final class ClientConfigurations {
    private static final SafeLogger log = SafeLoggerFactory.get(ClientConfigurations.class);
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(5L);
    private static final Duration DEFAULT_WRITE_TIMEOUT = Duration.ofMinutes(5L);
    private static final Duration DEFAULT_BACKOFF_SLOT_SIZE = Duration.ofMillis(250L);
    private static final Duration DEFAULT_FAILED_URL_COOLDOWN = Duration.ZERO;
    private static final boolean DEFAULT_ENABLE_GCM_CIPHERS = true;
    private static final boolean DEFAULT_FALLBACK_TO_COMMON_NAME_VERIFICATION = false;
    private static final NodeSelectionStrategy DEFAULT_NODE_SELECTION_STRATEGY = NodeSelectionStrategy.PIN_UNTIL_ERROR;
    private static final int DEFAULT_MAX_NUM_RETRIES = 4;
    private static final ClientConfiguration.ClientQoS CLIENT_QOS_DEFAULT = ClientConfiguration.ClientQoS.ENABLED;
    private static final ClientConfiguration.ServerQoS PROPAGATE_QOS_DEFAULT = ClientConfiguration.ServerQoS.AUTOMATIC_RETRY;
    private static final ClientConfiguration.RetryOnTimeout RETRY_ON_TIMEOUT_DEFAULT = ClientConfiguration.RetryOnTimeout.DISABLED;
    private static final ClientConfiguration.RetryOnSocketException RETRY_ON_SOCKET_EXCEPTION_DEFAULT = ClientConfiguration.RetryOnSocketException.ENABLED;
    private static final String ENV_HTTPS_PROXY = "https_proxy";

    private ClientConfigurations() {
    }

    public static ClientConfiguration of(ServiceConfiguration config) {
        return ClientConfigurations.of(config, SslSocketFactories::createTrustContext);
    }

    public static ClientConfiguration of(ServiceConfiguration config, TrustContextFactory factory) {
        TrustContext trustContext = factory.create(config.security());
        return ClientConfiguration.builder().sslSocketFactory(trustContext.sslSocketFactory()).trustManager(trustContext.x509TrustManager()).uris(config.uris()).connectTimeout(config.connectTimeout().orElse(DEFAULT_CONNECT_TIMEOUT)).readTimeout(config.readTimeout().orElse(DEFAULT_READ_TIMEOUT)).writeTimeout(config.writeTimeout().orElse(DEFAULT_WRITE_TIMEOUT)).enableGcmCipherSuites(config.enableGcmCipherSuites().orElse(true)).fallbackToCommonNameVerification(config.fallbackToCommonNameVerification().orElse(false)).proxy(config.proxy().map(ClientConfigurations::createProxySelector).orElseGet(ProxySelector::getDefault)).proxyCredentials(config.proxy().flatMap(ProxyConfiguration::credentials)).meshProxy(ClientConfigurations.meshProxy(config.proxy())).maxNumRetries(config.maxNumRetries().orElse(4)).nodeSelectionStrategy(DEFAULT_NODE_SELECTION_STRATEGY).failedUrlCooldown(DEFAULT_FAILED_URL_COOLDOWN).backoffSlotSize(config.backoffSlotSize().orElse(DEFAULT_BACKOFF_SLOT_SIZE)).clientQoS(CLIENT_QOS_DEFAULT).serverQoS(PROPAGATE_QOS_DEFAULT).retryOnTimeout(RETRY_ON_TIMEOUT_DEFAULT).retryOnSocketException(RETRY_ON_SOCKET_EXCEPTION_DEFAULT).taggedMetricRegistry(SharedTaggedMetricRegistries.getSingleton()).build();
    }

    public static ClientConfiguration of(List<String> uris, SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        return ClientConfigurations.of(uris, sslSocketFactory, trustManager, Optional.empty());
    }

    public static ClientConfiguration of(List<String> uris, SSLSocketFactory sslSocketFactory, X509TrustManager trustManager, UserAgent userAgent) {
        return ClientConfigurations.of(uris, sslSocketFactory, trustManager, Optional.of(userAgent));
    }

    private static ClientConfiguration of(List<String> uris, SSLSocketFactory sslSocketFactory, X509TrustManager trustManager, Optional<UserAgent> userAgent) {
        return ClientConfiguration.builder().sslSocketFactory(sslSocketFactory).trustManager(trustManager).uris(uris).connectTimeout(DEFAULT_CONNECT_TIMEOUT).readTimeout(DEFAULT_READ_TIMEOUT).writeTimeout(DEFAULT_WRITE_TIMEOUT).enableGcmCipherSuites(true).fallbackToCommonNameVerification(false).proxy(ProxySelector.getDefault()).proxyCredentials(Optional.empty()).maxNumRetries(4).backoffSlotSize(DEFAULT_BACKOFF_SLOT_SIZE).nodeSelectionStrategy(DEFAULT_NODE_SELECTION_STRATEGY).failedUrlCooldown(DEFAULT_FAILED_URL_COOLDOWN).clientQoS(CLIENT_QOS_DEFAULT).serverQoS(PROPAGATE_QOS_DEFAULT).retryOnTimeout(RETRY_ON_TIMEOUT_DEFAULT).retryOnSocketException(RETRY_ON_SOCKET_EXCEPTION_DEFAULT).taggedMetricRegistry(SharedTaggedMetricRegistries.getSingleton()).userAgent(userAgent).build();
    }

    public static ProxySelector createProxySelector(ProxyConfiguration proxyConfig) {
        switch (proxyConfig.type()) {
            case DIRECT: {
                return ClientConfigurations.fixedProxySelectorFor(Proxy.NO_PROXY);
            }
            case FROM_ENVIRONMENT: {
                String defaultEnvProxy = System.getenv(ENV_HTTPS_PROXY);
                if (defaultEnvProxy == null) {
                    log.info("Proxy environment variable not set, using no proxy");
                    return ClientConfigurations.fixedProxySelectorFor(Proxy.NO_PROXY);
                }
                log.info("Using proxy from environment variable", UnsafeArg.of("proxy", defaultEnvProxy));
                InetSocketAddress address = ClientConfigurations.createInetSocketAddress(defaultEnvProxy);
                return ClientConfigurations.fixedProxySelectorFor(new Proxy(Proxy.Type.HTTP, address));
            }
            case HTTP: {
                return ClientConfigurations.getHttpProxySelector(proxyConfig, false);
            }
            case HTTPS: {
                return ClientConfigurations.getHttpProxySelector(proxyConfig, true);
            }
            case MESH: {
                return ProxySelector.getDefault();
            }
            case SOCKS: {
                HostAndPort socksHostAndPort = HostAndPort.fromString(proxyConfig.hostAndPort().orElseThrow(() -> new SafeIllegalArgumentException("Expected to find proxy hostAndPort configuration for SOCKS proxy", new Arg[0])));
                InetSocketAddress socksAddress = InetSocketAddress.createUnresolved(socksHostAndPort.getHost(), socksHostAndPort.getPort());
                return ClientConfigurations.fixedProxySelectorFor(new Proxy(Proxy.Type.SOCKS, socksAddress));
            }
        }
        throw new SafeIllegalStateException("Failed to create ProxySelector for proxy configuration", SafeArg.of("type", proxyConfig.type()), UnsafeArg.of("hostAndPort", proxyConfig.hostAndPort()));
    }

    @VisibleForTesting
    static InetSocketAddress createInetSocketAddress(String uriString) {
        URI uri = URI.create(uriString);
        return InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
    }

    private static Optional<HostAndPort> meshProxy(Optional<ProxyConfiguration> proxy) {
        if (proxy.isPresent() && proxy.get().type() == ProxyConfiguration.Type.MESH) {
            return Optional.of(HostAndPort.fromString(proxy.get().hostAndPort().get()));
        }
        return Optional.empty();
    }

    private static ProxySelector getHttpProxySelector(ProxyConfiguration proxyConfig, boolean https) {
        HostAndPort httpsHostAndPort = HostAndPort.fromString(proxyConfig.hostAndPort().orElseThrow(() -> new SafeIllegalArgumentException("Expected to find proxy hostAndPort configuration for HTTP(S) proxy", new Arg[0])));
        InetSocketAddress address = InetSocketAddress.createUnresolved(httpsHostAndPort.getHost(), httpsHostAndPort.getPort());
        return ClientConfigurations.fixedProxySelectorFor(https ? HttpsProxies.create(address) : new Proxy(Proxy.Type.HTTP, address));
    }

    private static ProxySelector fixedProxySelectorFor(Proxy proxy) {
        return new FixedProxySelector(proxy);
    }

    public static interface TrustContextFactory {
        public TrustContext create(SslConfiguration var1);
    }

    private static final class FixedProxySelector
    extends ProxySelector {
        private final Proxy proxy;

        FixedProxySelector(Proxy proxy) {
            this.proxy = proxy;
        }

        @Override
        public List<Proxy> select(URI _uri) {
            return ImmutableList.of(this.proxy);
        }

        @Override
        public void connectFailed(URI _uri, SocketAddress _sa, IOException _ioe) {
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || FixedProxySelector.class != other.getClass()) {
                return false;
            }
            FixedProxySelector that = (FixedProxySelector)other;
            return this.proxy.equals(that.proxy);
        }

        public int hashCode() {
            return this.proxy.hashCode();
        }

        public String toString() {
            return "FixedProxySelector{proxy=" + this.proxy + "}";
        }
    }
}

