/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.client.config;

import java.net.ProxySelector;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import shadow.palantir.driver.com.google.common.net.HostAndPort;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.BasicCredentials;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.service.UserAgent;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.ClientConfiguration;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.HostEventsSink;
import shadow.palantir.driver.com.palantir.conjure.java.client.config.NodeSelectionStrategy;
import shadow.palantir.driver.com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientConfiguration", generator="Immutables")
@Immutable
final class ImmutableClientConfiguration
implements ClientConfiguration {
    private final SSLSocketFactory sslSocketFactory;
    private final X509TrustManager trustManager;
    private final List<String> uris;
    private final Duration connectTimeout;
    private final Duration readTimeout;
    private final Duration writeTimeout;
    private final boolean enableGcmCipherSuites;
    @Nullable
    private final Boolean enableHttp2;
    private final boolean fallbackToCommonNameVerification;
    private final ProxySelector proxy;
    @Nullable
    private final BasicCredentials proxyCredentials;
    @Nullable
    private final HostAndPort meshProxy;
    private final int maxNumRetries;
    private final NodeSelectionStrategy nodeSelectionStrategy;
    private final Duration failedUrlCooldown;
    private final Duration backoffSlotSize;
    private final ClientConfiguration.ClientQoS clientQoS;
    private final ClientConfiguration.ServerQoS serverQoS;
    private final ClientConfiguration.RetryOnTimeout retryOnTimeout;
    private final ClientConfiguration.RetryOnSocketException retryOnSocketException;
    private final TaggedMetricRegistry taggedMetricRegistry;
    @Nullable
    private final UserAgent userAgent;
    @Nullable
    private final HostEventsSink hostEventsSink;

    private ImmutableClientConfiguration(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager, List<String> uris, Duration connectTimeout, Duration readTimeout, Duration writeTimeout, boolean enableGcmCipherSuites, @Nullable Boolean enableHttp2, boolean fallbackToCommonNameVerification, ProxySelector proxy, @Nullable BasicCredentials proxyCredentials, @Nullable HostAndPort meshProxy, int maxNumRetries, NodeSelectionStrategy nodeSelectionStrategy, Duration failedUrlCooldown, Duration backoffSlotSize, ClientConfiguration.ClientQoS clientQoS, ClientConfiguration.ServerQoS serverQoS, ClientConfiguration.RetryOnTimeout retryOnTimeout, ClientConfiguration.RetryOnSocketException retryOnSocketException, TaggedMetricRegistry taggedMetricRegistry, @Nullable UserAgent userAgent, @Nullable HostEventsSink hostEventsSink) {
        this.sslSocketFactory = sslSocketFactory;
        this.trustManager = trustManager;
        this.uris = uris;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.enableGcmCipherSuites = enableGcmCipherSuites;
        this.enableHttp2 = enableHttp2;
        this.fallbackToCommonNameVerification = fallbackToCommonNameVerification;
        this.proxy = proxy;
        this.proxyCredentials = proxyCredentials;
        this.meshProxy = meshProxy;
        this.maxNumRetries = maxNumRetries;
        this.nodeSelectionStrategy = nodeSelectionStrategy;
        this.failedUrlCooldown = failedUrlCooldown;
        this.backoffSlotSize = backoffSlotSize;
        this.clientQoS = clientQoS;
        this.serverQoS = serverQoS;
        this.retryOnTimeout = retryOnTimeout;
        this.retryOnSocketException = retryOnSocketException;
        this.taggedMetricRegistry = taggedMetricRegistry;
        this.userAgent = userAgent;
        this.hostEventsSink = hostEventsSink;
    }

    @Override
    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public X509TrustManager trustManager() {
        return this.trustManager;
    }

    @Override
    public List<String> uris() {
        return this.uris;
    }

    @Override
    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public Duration readTimeout() {
        return this.readTimeout;
    }

    @Override
    public Duration writeTimeout() {
        return this.writeTimeout;
    }

    @Override
    public boolean enableGcmCipherSuites() {
        return this.enableGcmCipherSuites;
    }

    @Override
    public Optional<Boolean> enableHttp2() {
        return Optional.ofNullable(this.enableHttp2);
    }

    @Override
    public boolean fallbackToCommonNameVerification() {
        return this.fallbackToCommonNameVerification;
    }

    @Override
    public ProxySelector proxy() {
        return this.proxy;
    }

    @Override
    public Optional<BasicCredentials> proxyCredentials() {
        return Optional.ofNullable(this.proxyCredentials);
    }

    @Override
    public Optional<HostAndPort> meshProxy() {
        return Optional.ofNullable(this.meshProxy);
    }

    @Override
    public int maxNumRetries() {
        return this.maxNumRetries;
    }

    @Override
    public NodeSelectionStrategy nodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    @Override
    public Duration failedUrlCooldown() {
        return this.failedUrlCooldown;
    }

    @Override
    public Duration backoffSlotSize() {
        return this.backoffSlotSize;
    }

    @Override
    public ClientConfiguration.ClientQoS clientQoS() {
        return this.clientQoS;
    }

    @Override
    public ClientConfiguration.ServerQoS serverQoS() {
        return this.serverQoS;
    }

    @Override
    public ClientConfiguration.RetryOnTimeout retryOnTimeout() {
        return this.retryOnTimeout;
    }

    @Override
    public ClientConfiguration.RetryOnSocketException retryOnSocketException() {
        return this.retryOnSocketException;
    }

    @Override
    public TaggedMetricRegistry taggedMetricRegistry() {
        return this.taggedMetricRegistry;
    }

    @Override
    public Optional<UserAgent> userAgent() {
        return Optional.ofNullable(this.userAgent);
    }

    @Override
    public Optional<HostEventsSink> hostEventsSink() {
        return Optional.ofNullable(this.hostEventsSink);
    }

    public final ImmutableClientConfiguration withSslSocketFactory(SSLSocketFactory value) {
        if (this.sslSocketFactory == value) {
            return this;
        }
        SSLSocketFactory newValue = Objects.requireNonNull(value, "sslSocketFactory");
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(newValue, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withTrustManager(X509TrustManager value) {
        if (this.trustManager == value) {
            return this;
        }
        X509TrustManager newValue = Objects.requireNonNull(value, "trustManager");
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, newValue, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withUris(String ... elements) {
        List<String> newValue = ImmutableClientConfiguration.createUnmodifiableList(false, ImmutableClientConfiguration.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, newValue, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withUris(Iterable<String> elements) {
        if (this.uris == elements) {
            return this;
        }
        List<String> newValue = ImmutableClientConfiguration.createUnmodifiableList(false, ImmutableClientConfiguration.createSafeList(elements, true, false));
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, newValue, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withConnectTimeout(Duration value) {
        if (this.connectTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "connectTimeout");
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, newValue, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withReadTimeout(Duration value) {
        if (this.readTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "readTimeout");
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, newValue, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withWriteTimeout(Duration value) {
        if (this.writeTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "writeTimeout");
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, newValue, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withEnableGcmCipherSuites(boolean value) {
        if (this.enableGcmCipherSuites == value) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, value, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withEnableHttp2(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableHttp2, newValue)) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, newValue, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withEnableHttp2(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableHttp2, value)) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, value, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withFallbackToCommonNameVerification(boolean value) {
        if (this.fallbackToCommonNameVerification == value) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, value, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withProxy(ProxySelector value) {
        if (this.proxy == value) {
            return this;
        }
        ProxySelector newValue = Objects.requireNonNull(value, "proxy");
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, newValue, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withProxyCredentials(BasicCredentials value) {
        BasicCredentials newValue = Objects.requireNonNull(value, "proxyCredentials");
        if (this.proxyCredentials == newValue) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, newValue, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withProxyCredentials(Optional<? extends BasicCredentials> optional) {
        BasicCredentials value = optional.orElse(null);
        if (this.proxyCredentials == value) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, value, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withMeshProxy(HostAndPort value) {
        HostAndPort newValue = Objects.requireNonNull(value, "meshProxy");
        if (this.meshProxy == newValue) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, newValue, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withMeshProxy(Optional<? extends HostAndPort> optional) {
        HostAndPort value = optional.orElse(null);
        if (this.meshProxy == value) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, value, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withMaxNumRetries(int value) {
        if (this.maxNumRetries == value) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, value, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withNodeSelectionStrategy(NodeSelectionStrategy value) {
        NodeSelectionStrategy newValue = Objects.requireNonNull(value, "nodeSelectionStrategy");
        if (this.nodeSelectionStrategy == newValue) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, newValue, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withFailedUrlCooldown(Duration value) {
        if (this.failedUrlCooldown == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "failedUrlCooldown");
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, newValue, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withBackoffSlotSize(Duration value) {
        if (this.backoffSlotSize == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "backoffSlotSize");
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, newValue, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withClientQoS(ClientConfiguration.ClientQoS value) {
        ClientConfiguration.ClientQoS newValue = Objects.requireNonNull(value, "clientQoS");
        if (this.clientQoS == newValue) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, newValue, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withServerQoS(ClientConfiguration.ServerQoS value) {
        ClientConfiguration.ServerQoS newValue = Objects.requireNonNull(value, "serverQoS");
        if (this.serverQoS == newValue) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, newValue, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withRetryOnTimeout(ClientConfiguration.RetryOnTimeout value) {
        ClientConfiguration.RetryOnTimeout newValue = Objects.requireNonNull(value, "retryOnTimeout");
        if (this.retryOnTimeout == newValue) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, newValue, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withRetryOnSocketException(ClientConfiguration.RetryOnSocketException value) {
        ClientConfiguration.RetryOnSocketException newValue = Objects.requireNonNull(value, "retryOnSocketException");
        if (this.retryOnSocketException == newValue) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, newValue, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withTaggedMetricRegistry(TaggedMetricRegistry value) {
        if (this.taggedMetricRegistry == value) {
            return this;
        }
        TaggedMetricRegistry newValue = Objects.requireNonNull(value, "taggedMetricRegistry");
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, newValue, this.userAgent, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withUserAgent(UserAgent value) {
        UserAgent newValue = Objects.requireNonNull(value, "userAgent");
        if (this.userAgent == newValue) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, newValue, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withUserAgent(Optional<? extends UserAgent> optional) {
        UserAgent value = optional.orElse(null);
        if (this.userAgent == value) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, value, this.hostEventsSink));
    }

    public final ImmutableClientConfiguration withHostEventsSink(HostEventsSink value) {
        HostEventsSink newValue = Objects.requireNonNull(value, "hostEventsSink");
        if (this.hostEventsSink == newValue) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, newValue));
    }

    public final ImmutableClientConfiguration withHostEventsSink(Optional<? extends HostEventsSink> optional) {
        HostEventsSink value = optional.orElse(null);
        if (this.hostEventsSink == value) {
            return this;
        }
        return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientConfiguration && this.equalTo(0, (ImmutableClientConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableClientConfiguration another) {
        return this.sslSocketFactory.equals(another.sslSocketFactory) && this.trustManager.equals(another.trustManager) && this.uris.equals(another.uris) && this.connectTimeout.equals(another.connectTimeout) && this.readTimeout.equals(another.readTimeout) && this.writeTimeout.equals(another.writeTimeout) && this.enableGcmCipherSuites == another.enableGcmCipherSuites && Objects.equals(this.enableHttp2, another.enableHttp2) && this.fallbackToCommonNameVerification == another.fallbackToCommonNameVerification && this.proxy.equals(another.proxy) && Objects.equals(this.proxyCredentials, another.proxyCredentials) && Objects.equals(this.meshProxy, another.meshProxy) && this.maxNumRetries == another.maxNumRetries && this.nodeSelectionStrategy.equals((Object)another.nodeSelectionStrategy) && this.failedUrlCooldown.equals(another.failedUrlCooldown) && this.backoffSlotSize.equals(another.backoffSlotSize) && this.clientQoS.equals((Object)another.clientQoS) && this.serverQoS.equals((Object)another.serverQoS) && this.retryOnTimeout.equals((Object)another.retryOnTimeout) && this.retryOnSocketException.equals((Object)another.retryOnSocketException) && this.taggedMetricRegistry.equals(another.taggedMetricRegistry) && Objects.equals(this.userAgent, another.userAgent) && Objects.equals(this.hostEventsSink, another.hostEventsSink);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sslSocketFactory.hashCode();
        h += (h << 5) + this.trustManager.hashCode();
        h += (h << 5) + this.uris.hashCode();
        h += (h << 5) + this.connectTimeout.hashCode();
        h += (h << 5) + this.readTimeout.hashCode();
        h += (h << 5) + this.writeTimeout.hashCode();
        h += (h << 5) + Boolean.hashCode(this.enableGcmCipherSuites);
        h += (h << 5) + Objects.hashCode(this.enableHttp2);
        h += (h << 5) + Boolean.hashCode(this.fallbackToCommonNameVerification);
        h += (h << 5) + this.proxy.hashCode();
        h += (h << 5) + Objects.hashCode(this.proxyCredentials);
        h += (h << 5) + Objects.hashCode(this.meshProxy);
        h += (h << 5) + this.maxNumRetries;
        h += (h << 5) + this.nodeSelectionStrategy.hashCode();
        h += (h << 5) + this.failedUrlCooldown.hashCode();
        h += (h << 5) + this.backoffSlotSize.hashCode();
        h += (h << 5) + this.clientQoS.hashCode();
        h += (h << 5) + this.serverQoS.hashCode();
        h += (h << 5) + this.retryOnTimeout.hashCode();
        h += (h << 5) + this.retryOnSocketException.hashCode();
        h += (h << 5) + this.taggedMetricRegistry.hashCode();
        h += (h << 5) + Objects.hashCode(this.userAgent);
        h += (h << 5) + Objects.hashCode(this.hostEventsSink);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ClientConfiguration{");
        builder.append("sslSocketFactory=").append(this.sslSocketFactory);
        builder.append(", ");
        builder.append("trustManager=").append(this.trustManager);
        builder.append(", ");
        builder.append("uris=").append(this.uris);
        builder.append(", ");
        builder.append("connectTimeout=").append(this.connectTimeout);
        builder.append(", ");
        builder.append("readTimeout=").append(this.readTimeout);
        builder.append(", ");
        builder.append("writeTimeout=").append(this.writeTimeout);
        builder.append(", ");
        builder.append("enableGcmCipherSuites=").append(this.enableGcmCipherSuites);
        if (this.enableHttp2 != null) {
            builder.append(", ");
            builder.append("enableHttp2=").append(this.enableHttp2);
        }
        builder.append(", ");
        builder.append("fallbackToCommonNameVerification=").append(this.fallbackToCommonNameVerification);
        builder.append(", ");
        builder.append("proxy=").append(this.proxy);
        if (this.proxyCredentials != null) {
            builder.append(", ");
            builder.append("proxyCredentials=").append(this.proxyCredentials);
        }
        if (this.meshProxy != null) {
            builder.append(", ");
            builder.append("meshProxy=").append(this.meshProxy);
        }
        builder.append(", ");
        builder.append("maxNumRetries=").append(this.maxNumRetries);
        builder.append(", ");
        builder.append("nodeSelectionStrategy=").append((Object)this.nodeSelectionStrategy);
        builder.append(", ");
        builder.append("failedUrlCooldown=").append(this.failedUrlCooldown);
        builder.append(", ");
        builder.append("backoffSlotSize=").append(this.backoffSlotSize);
        builder.append(", ");
        builder.append("clientQoS=").append((Object)this.clientQoS);
        builder.append(", ");
        builder.append("serverQoS=").append((Object)this.serverQoS);
        builder.append(", ");
        builder.append("retryOnTimeout=").append((Object)this.retryOnTimeout);
        builder.append(", ");
        builder.append("retryOnSocketException=").append((Object)this.retryOnSocketException);
        builder.append(", ");
        builder.append("taggedMetricRegistry=").append(this.taggedMetricRegistry);
        if (this.userAgent != null) {
            builder.append(", ");
            builder.append("userAgent=").append(this.userAgent);
        }
        if (this.hostEventsSink != null) {
            builder.append(", ");
            builder.append("hostEventsSink=").append(this.hostEventsSink);
        }
        return builder.append("}").toString();
    }

    private static ImmutableClientConfiguration validate(ImmutableClientConfiguration instance) {
        instance.check();
        return instance;
    }

    public static ClientConfiguration copyOf(ClientConfiguration instance) {
        if (instance instanceof ImmutableClientConfiguration) {
            return (ImmutableClientConfiguration)instance;
        }
        return new ClientConfiguration.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ClientConfiguration", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_SSL_SOCKET_FACTORY = 1L;
        private static final long INIT_BIT_TRUST_MANAGER = 2L;
        private static final long INIT_BIT_CONNECT_TIMEOUT = 4L;
        private static final long INIT_BIT_READ_TIMEOUT = 8L;
        private static final long INIT_BIT_WRITE_TIMEOUT = 16L;
        private static final long INIT_BIT_ENABLE_GCM_CIPHER_SUITES = 32L;
        private static final long INIT_BIT_FALLBACK_TO_COMMON_NAME_VERIFICATION = 64L;
        private static final long INIT_BIT_PROXY = 128L;
        private static final long INIT_BIT_MAX_NUM_RETRIES = 256L;
        private static final long INIT_BIT_NODE_SELECTION_STRATEGY = 512L;
        private static final long INIT_BIT_FAILED_URL_COOLDOWN = 1024L;
        private static final long INIT_BIT_BACKOFF_SLOT_SIZE = 2048L;
        private static final long INIT_BIT_CLIENT_QO_S = 4096L;
        private static final long INIT_BIT_SERVER_QO_S = 8192L;
        private static final long INIT_BIT_RETRY_ON_TIMEOUT = 16384L;
        private static final long INIT_BIT_RETRY_ON_SOCKET_EXCEPTION = 32768L;
        private static final long INIT_BIT_TAGGED_METRIC_REGISTRY = 65536L;
        private long initBits = 131071L;
        @Nullable
        private SSLSocketFactory sslSocketFactory;
        @Nullable
        private X509TrustManager trustManager;
        private List<String> uris = new ArrayList<String>();
        @Nullable
        private Duration connectTimeout;
        @Nullable
        private Duration readTimeout;
        @Nullable
        private Duration writeTimeout;
        private boolean enableGcmCipherSuites;
        @Nullable
        private Boolean enableHttp2;
        private boolean fallbackToCommonNameVerification;
        @Nullable
        private ProxySelector proxy;
        @Nullable
        private BasicCredentials proxyCredentials;
        @Nullable
        private HostAndPort meshProxy;
        private int maxNumRetries;
        @Nullable
        private NodeSelectionStrategy nodeSelectionStrategy;
        @Nullable
        private Duration failedUrlCooldown;
        @Nullable
        private Duration backoffSlotSize;
        @Nullable
        private ClientConfiguration.ClientQoS clientQoS;
        @Nullable
        private ClientConfiguration.ServerQoS serverQoS;
        @Nullable
        private ClientConfiguration.RetryOnTimeout retryOnTimeout;
        @Nullable
        private ClientConfiguration.RetryOnSocketException retryOnSocketException;
        @Nullable
        private TaggedMetricRegistry taggedMetricRegistry;
        @Nullable
        private UserAgent userAgent;
        @Nullable
        private HostEventsSink hostEventsSink;

        public Builder() {
            if (!(this instanceof ClientConfiguration.Builder)) {
                throw new UnsupportedOperationException("Use: new ClientConfiguration.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder from(ClientConfiguration instance) {
            Optional<HostEventsSink> hostEventsSinkOptional;
            Optional<HostAndPort> meshProxyOptional;
            Objects.requireNonNull(instance, "instance");
            this.sslSocketFactory(instance.sslSocketFactory());
            this.trustManager(instance.trustManager());
            this.addAllUris(instance.uris());
            this.connectTimeout(instance.connectTimeout());
            this.readTimeout(instance.readTimeout());
            this.writeTimeout(instance.writeTimeout());
            this.enableGcmCipherSuites(instance.enableGcmCipherSuites());
            Optional<Boolean> enableHttp2Optional = instance.enableHttp2();
            if (enableHttp2Optional.isPresent()) {
                this.enableHttp2(enableHttp2Optional);
            }
            this.fallbackToCommonNameVerification(instance.fallbackToCommonNameVerification());
            this.proxy(instance.proxy());
            Optional<BasicCredentials> proxyCredentialsOptional = instance.proxyCredentials();
            if (proxyCredentialsOptional.isPresent()) {
                this.proxyCredentials(proxyCredentialsOptional);
            }
            if ((meshProxyOptional = instance.meshProxy()).isPresent()) {
                this.meshProxy(meshProxyOptional);
            }
            this.maxNumRetries(instance.maxNumRetries());
            this.nodeSelectionStrategy(instance.nodeSelectionStrategy());
            this.failedUrlCooldown(instance.failedUrlCooldown());
            this.backoffSlotSize(instance.backoffSlotSize());
            this.clientQoS(instance.clientQoS());
            this.serverQoS(instance.serverQoS());
            this.retryOnTimeout(instance.retryOnTimeout());
            this.retryOnSocketException(instance.retryOnSocketException());
            this.taggedMetricRegistry(instance.taggedMetricRegistry());
            Optional<UserAgent> userAgentOptional = instance.userAgent();
            if (userAgentOptional.isPresent()) {
                this.userAgent(userAgentOptional);
            }
            if ((hostEventsSinkOptional = instance.hostEventsSink()).isPresent()) {
                this.hostEventsSink(hostEventsSinkOptional);
            }
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = Objects.requireNonNull(sslSocketFactory, "sslSocketFactory");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder trustManager(X509TrustManager trustManager) {
            this.trustManager = Objects.requireNonNull(trustManager, "trustManager");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder addUris(String element) {
            this.uris.add(Objects.requireNonNull(element, "uris element"));
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder addUris(String ... elements) {
            for (String element : elements) {
                this.uris.add(Objects.requireNonNull(element, "uris element"));
            }
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder uris(Iterable<String> elements) {
            this.uris.clear();
            return this.addAllUris(elements);
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder addAllUris(Iterable<String> elements) {
            for (String element : elements) {
                this.uris.add(Objects.requireNonNull(element, "uris element"));
            }
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = Objects.requireNonNull(connectTimeout, "connectTimeout");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder readTimeout(Duration readTimeout) {
            this.readTimeout = Objects.requireNonNull(readTimeout, "readTimeout");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = Objects.requireNonNull(writeTimeout, "writeTimeout");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder enableGcmCipherSuites(boolean enableGcmCipherSuites) {
            this.enableGcmCipherSuites = enableGcmCipherSuites;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder enableHttp2(boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder enableHttp2(Optional<Boolean> enableHttp2) {
            this.enableHttp2 = enableHttp2.orElse(null);
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder fallbackToCommonNameVerification(boolean fallbackToCommonNameVerification) {
            this.fallbackToCommonNameVerification = fallbackToCommonNameVerification;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder proxy(ProxySelector proxy) {
            this.proxy = Objects.requireNonNull(proxy, "proxy");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder proxyCredentials(BasicCredentials proxyCredentials) {
            this.proxyCredentials = Objects.requireNonNull(proxyCredentials, "proxyCredentials");
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder proxyCredentials(Optional<? extends BasicCredentials> proxyCredentials) {
            this.proxyCredentials = proxyCredentials.orElse(null);
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder meshProxy(HostAndPort meshProxy) {
            this.meshProxy = Objects.requireNonNull(meshProxy, "meshProxy");
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder meshProxy(Optional<? extends HostAndPort> meshProxy) {
            this.meshProxy = meshProxy.orElse(null);
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder maxNumRetries(int maxNumRetries) {
            this.maxNumRetries = maxNumRetries;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder nodeSelectionStrategy(NodeSelectionStrategy nodeSelectionStrategy) {
            this.nodeSelectionStrategy = Objects.requireNonNull(nodeSelectionStrategy, "nodeSelectionStrategy");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder failedUrlCooldown(Duration failedUrlCooldown) {
            this.failedUrlCooldown = Objects.requireNonNull(failedUrlCooldown, "failedUrlCooldown");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder backoffSlotSize(Duration backoffSlotSize) {
            this.backoffSlotSize = Objects.requireNonNull(backoffSlotSize, "backoffSlotSize");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder clientQoS(ClientConfiguration.ClientQoS clientQoS) {
            this.clientQoS = Objects.requireNonNull(clientQoS, "clientQoS");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder serverQoS(ClientConfiguration.ServerQoS serverQoS) {
            this.serverQoS = Objects.requireNonNull(serverQoS, "serverQoS");
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder retryOnTimeout(ClientConfiguration.RetryOnTimeout retryOnTimeout) {
            this.retryOnTimeout = Objects.requireNonNull(retryOnTimeout, "retryOnTimeout");
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder retryOnSocketException(ClientConfiguration.RetryOnSocketException retryOnSocketException) {
            this.retryOnSocketException = Objects.requireNonNull(retryOnSocketException, "retryOnSocketException");
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder taggedMetricRegistry(TaggedMetricRegistry taggedMetricRegistry) {
            this.taggedMetricRegistry = Objects.requireNonNull(taggedMetricRegistry, "taggedMetricRegistry");
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder userAgent(UserAgent userAgent) {
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder userAgent(Optional<? extends UserAgent> userAgent) {
            this.userAgent = userAgent.orElse(null);
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder hostEventsSink(HostEventsSink hostEventsSink) {
            this.hostEventsSink = Objects.requireNonNull(hostEventsSink, "hostEventsSink");
            return (ClientConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ClientConfiguration.Builder hostEventsSink(Optional<? extends HostEventsSink> hostEventsSink) {
            this.hostEventsSink = hostEventsSink.orElse(null);
            return (ClientConfiguration.Builder)this;
        }

        public ClientConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableClientConfiguration.validate(new ImmutableClientConfiguration(this.sslSocketFactory, this.trustManager, ImmutableClientConfiguration.createUnmodifiableList(true, this.uris), this.connectTimeout, this.readTimeout, this.writeTimeout, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy, this.proxyCredentials, this.meshProxy, this.maxNumRetries, this.nodeSelectionStrategy, this.failedUrlCooldown, this.backoffSlotSize, this.clientQoS, this.serverQoS, this.retryOnTimeout, this.retryOnSocketException, this.taggedMetricRegistry, this.userAgent, this.hostEventsSink));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sslSocketFactory");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("trustManager");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("connectTimeout");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("readTimeout");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("writeTimeout");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("enableGcmCipherSuites");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("fallbackToCommonNameVerification");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("proxy");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("maxNumRetries");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("nodeSelectionStrategy");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("failedUrlCooldown");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("backoffSlotSize");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("clientQoS");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("serverQoS");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("retryOnTimeout");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("retryOnSocketException");
            }
            if ((this.initBits & 0x10000L) != 0L) {
                attributes.add("taggedMetricRegistry");
            }
            return "Cannot build ClientConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

