/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.config.ssl;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

final class ConscryptCompatTrustManagers {
    static TrustManager[] wrap(TrustManager[] trustManager) {
        if (trustManager == null || trustManager.length == 0) {
            return trustManager;
        }
        TrustManager[] managers = new TrustManager[trustManager.length];
        for (int i = 0; i < managers.length; ++i) {
            managers[i] = ConscryptCompatTrustManagers.wrap(trustManager[i]);
        }
        return managers;
    }

    static TrustManager wrap(TrustManager trustManager) {
        if (trustManager.getClass().getName().contains("org.conscrypt")) {
            return trustManager;
        }
        if (trustManager instanceof ConscryptCompatX509TrustManager || trustManager instanceof ConscryptCompatX509ExtendedTrustManager) {
            return trustManager;
        }
        if (trustManager instanceof X509ExtendedTrustManager) {
            return new ConscryptCompatX509ExtendedTrustManager((X509ExtendedTrustManager)trustManager);
        }
        if (trustManager instanceof X509TrustManager) {
            return new ConscryptCompatX509TrustManager((X509TrustManager)trustManager);
        }
        return trustManager;
    }

    private static String conscryptToOpenjdkAuthType(String authType) {
        if ("GENERIC".equals(authType)) {
            return "UNKNOWN";
        }
        return authType;
    }

    private ConscryptCompatTrustManagers() {
    }

    private static final class ConscryptCompatX509ExtendedTrustManager
    extends X509ExtendedTrustManager {
        private final X509ExtendedTrustManager delegate;

        ConscryptCompatX509ExtendedTrustManager(X509ExtendedTrustManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            this.delegate.checkServerTrusted(chain, ConscryptCompatTrustManagers.conscryptToOpenjdkAuthType(authType), socket);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            this.delegate.checkServerTrusted(chain, ConscryptCompatTrustManagers.conscryptToOpenjdkAuthType(authType), engine);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.checkServerTrusted(chain, ConscryptCompatTrustManagers.conscryptToOpenjdkAuthType(authType));
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            this.delegate.checkClientTrusted(chain, ConscryptCompatTrustManagers.conscryptToOpenjdkAuthType(authType), socket);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            this.delegate.checkClientTrusted(chain, ConscryptCompatTrustManagers.conscryptToOpenjdkAuthType(authType), engine);
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.checkClientTrusted(chain, ConscryptCompatTrustManagers.conscryptToOpenjdkAuthType(authType));
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.delegate.getAcceptedIssuers();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ConscryptCompatX509ExtendedTrustManager that = (ConscryptCompatX509ExtendedTrustManager)other;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return "ConscryptCompatX509ExtendedTrustManager{" + this.delegate + "}";
        }
    }

    private static final class ConscryptCompatX509TrustManager
    implements X509TrustManager {
        private final X509TrustManager delegate;

        ConscryptCompatX509TrustManager(X509TrustManager delegate) {
            this.delegate = delegate;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.checkServerTrusted(chain, ConscryptCompatTrustManagers.conscryptToOpenjdkAuthType(authType));
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.checkClientTrusted(chain, ConscryptCompatTrustManagers.conscryptToOpenjdkAuthType(authType));
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.delegate.getAcceptedIssuers();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ConscryptCompatX509TrustManager that = (ConscryptCompatX509TrustManager)other;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return "ConscryptCompatX509TrustManager{" + this.delegate + "}";
        }
    }
}

