/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.config.ssl;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import shadow.palantir.driver.com.google.common.base.Suppliers;
import shadow.palantir.driver.com.google.common.collect.ImmutableMap;
import shadow.palantir.driver.com.google.common.hash.Hashing;
import shadow.palantir.driver.com.google.common.io.Resources;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.KeyStores;

final class DefaultCas {
    private static final SafeLogger log = SafeLoggerFactory.get(DefaultCas.class);
    private static final String CA_CERTIFICATES_CRT = "ca-certificates.crt";
    private static final Supplier<Map<String, X509Certificate>> TRUSTED_CERTIFICATES = Suppliers.memoize(DefaultCas::getTrustedCertificates);

    static Map<String, X509Certificate> getCertificates() {
        return TRUSTED_CERTIFICATES.get();
    }

    private static Map<String, X509Certificate> getTrustedCertificates() {
        ImmutableMap.Builder<CallSite, X509Certificate> certificateMap = ImmutableMap.builder();
        try {
            List caCertificates = KeyStores.readX509Certificates(new ByteArrayInputStream(Resources.toByteArray(Resources.getResource(DefaultCas.class, CA_CERTIFICATES_CRT)))).stream().map(cert -> (X509Certificate)cert).collect(Collectors.toList());
            int index = 0;
            for (X509Certificate cert2 : caCertificates) {
                String certificateCommonName = cert2.getSubjectX500Principal().getName().toLowerCase(Locale.ENGLISH);
                certificateMap.put((CallSite)((Object)(certificateCommonName + index)), cert2);
                log.debug("Adding CA certificate", SafeArg.of("certificateIndex", index), SafeArg.of("certificateCount", caCertificates.size()), SafeArg.of("certificateCommonName", certificateCommonName), SafeArg.of("expiry", cert2.getNotAfter()), SafeArg.of("sha256Fingerprint", Hashing.sha256().hashBytes(cert2.getEncoded()).toString()));
                ++index;
            }
        }
        catch (IOException | CertificateException e) {
            throw new SafeRuntimeException("Could not read file as an X.509 certificate", (Throwable)e, new Arg[0]);
        }
        return certificateMap.buildOrThrow();
    }

    private DefaultCas() {
    }
}

