/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.config.ssl;

import java.util.ArrayList;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import shadow.palantir.driver.com.google.common.base.MoreObjects;
import shadow.palantir.driver.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.TrustContext;
import shadow.palantir.driver.javax.annotation.CheckReturnValue;
import shadow.palantir.driver.javax.annotation.Nullable;
import shadow.palantir.driver.javax.annotation.ParametersAreNonnullByDefault;
import shadow.palantir.driver.javax.annotation.concurrent.Immutable;
import shadow.palantir.driver.javax.annotation.concurrent.NotThreadSafe;
import shadow.palantir.driver.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TrustContext", generator="Immutables")
@Immutable
public final class ImmutableTrustContext
extends TrustContext {
    private final SSLSocketFactory sslSocketFactory;
    private final X509TrustManager x509TrustManager;

    private ImmutableTrustContext(SSLSocketFactory sslSocketFactory, X509TrustManager x509TrustManager) {
        this.sslSocketFactory = Objects.requireNonNull(sslSocketFactory, "sslSocketFactory");
        this.x509TrustManager = Objects.requireNonNull(x509TrustManager, "x509TrustManager");
    }

    private ImmutableTrustContext(ImmutableTrustContext original, SSLSocketFactory sslSocketFactory, X509TrustManager x509TrustManager) {
        this.sslSocketFactory = sslSocketFactory;
        this.x509TrustManager = x509TrustManager;
    }

    @Override
    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public X509TrustManager x509TrustManager() {
        return this.x509TrustManager;
    }

    public final ImmutableTrustContext withSslSocketFactory(SSLSocketFactory value) {
        if (this.sslSocketFactory == value) {
            return this;
        }
        SSLSocketFactory newValue = Objects.requireNonNull(value, "sslSocketFactory");
        return new ImmutableTrustContext(this, newValue, this.x509TrustManager);
    }

    public final ImmutableTrustContext withX509TrustManager(X509TrustManager value) {
        if (this.x509TrustManager == value) {
            return this;
        }
        X509TrustManager newValue = Objects.requireNonNull(value, "x509TrustManager");
        return new ImmutableTrustContext(this, this.sslSocketFactory, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTrustContext && this.equalTo(0, (ImmutableTrustContext)another);
    }

    private boolean equalTo(int synthetic, ImmutableTrustContext another) {
        return this.sslSocketFactory.equals(another.sslSocketFactory) && this.x509TrustManager.equals(another.x509TrustManager);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sslSocketFactory.hashCode();
        h += (h << 5) + this.x509TrustManager.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TrustContext").omitNullValues().add("sslSocketFactory", this.sslSocketFactory).add("x509TrustManager", this.x509TrustManager).toString();
    }

    public static ImmutableTrustContext of(SSLSocketFactory sslSocketFactory, X509TrustManager x509TrustManager) {
        return new ImmutableTrustContext(sslSocketFactory, x509TrustManager);
    }

    public static ImmutableTrustContext copyOf(TrustContext instance) {
        if (instance instanceof ImmutableTrustContext) {
            return (ImmutableTrustContext)instance;
        }
        return ImmutableTrustContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TrustContext", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SSL_SOCKET_FACTORY = 1L;
        private static final long INIT_BIT_X509_TRUST_MANAGER = 2L;
        private long initBits = 3L;
        @Nullable
        private SSLSocketFactory sslSocketFactory;
        @Nullable
        private X509TrustManager x509TrustManager;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TrustContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.sslSocketFactory(instance.sslSocketFactory());
            this.x509TrustManager(instance.x509TrustManager());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = Objects.requireNonNull(sslSocketFactory, "sslSocketFactory");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder x509TrustManager(X509TrustManager x509TrustManager) {
            this.x509TrustManager = Objects.requireNonNull(x509TrustManager, "x509TrustManager");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTrustContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTrustContext(null, this.sslSocketFactory, this.x509TrustManager);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sslSocketFactory");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("x509TrustManager");
            }
            return "Cannot build TrustContext, some of required attributes are not set " + attributes;
        }
    }
}

