/*
 * Decompiled with CFR 0.152.
 */
package shadow.palantir.driver.com.palantir.conjure.java.config.ssl;

import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import shadow.palantir.driver.com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.ConscryptCompatTrustManagers;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.DefaultCas;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.KeyStores;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.PemX509Certificate;
import shadow.palantir.driver.com.palantir.conjure.java.config.ssl.TrustContext;
import shadow.palantir.driver.javax.annotation.Nullable;

public final class SslSocketFactories {
    private SslSocketFactories() {
    }

    public static SSLSocketFactory createSslSocketFactory(SslConfiguration config) {
        SSLContext sslContext = SslSocketFactories.createSslContext(config);
        return sslContext.getSocketFactory();
    }

    public static SSLSocketFactory createSslSocketFactory(SslConfiguration config, Provider provider) {
        SSLContext sslContext = SslSocketFactories.createSslContext(config, provider);
        return sslContext.getSocketFactory();
    }

    public static SSLSocketFactory createSslSocketFactory(Map<String, PemX509Certificate> trustCertificatesByAlias) {
        SSLContext sslContext = SslSocketFactories.createSslContext(trustCertificatesByAlias);
        return sslContext.getSocketFactory();
    }

    public static SSLSocketFactory createSslSocketFactory(Map<String, PemX509Certificate> trustCertificatesByAlias, Provider provider) {
        SSLContext sslContext = SslSocketFactories.createSslContext(trustCertificatesByAlias, provider);
        return sslContext.getSocketFactory();
    }

    public static SSLContext createSslContext(SslConfiguration config) {
        TrustManager[] trustManagers = SslSocketFactories.createTrustManagers(config);
        KeyManager[] keyManagers = SslSocketFactories.createKeyManagers(config);
        return SslSocketFactories.createSslContext(trustManagers, keyManagers);
    }

    public static SSLContext createSslContext(SslConfiguration config, Provider provider) {
        TrustManager[] trustManagers = SslSocketFactories.createTrustManagers(config);
        KeyManager[] keyManagers = SslSocketFactories.createKeyManagers(config);
        return SslSocketFactories.createSslContext(trustManagers, keyManagers, provider);
    }

    public static SSLContext createSslContext(Map<String, PemX509Certificate> trustCertificatesByAlias) {
        TrustManager[] trustManagers = SslSocketFactories.createTrustManagers(trustCertificatesByAlias);
        return SslSocketFactories.createSslContext(trustManagers, new KeyManager[0]);
    }

    public static SSLContext createSslContext(Map<String, PemX509Certificate> trustCertificatesByAlias, Provider provider) {
        TrustManager[] trustManagers = SslSocketFactories.createTrustManagers(trustCertificatesByAlias);
        return SslSocketFactories.createSslContext(trustManagers, new KeyManager[0], provider);
    }

    public static SSLContext createSslContext(TrustManager[] trustManagers, @Nullable KeyManager[] keyManagers) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static SSLContext createSslContext(TrustManager[] trustManagers, @Nullable KeyManager[] keyManagers, Provider provider) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS", provider);
            sslContext.init(keyManagers, ConscryptCompatTrustManagers.wrap(trustManagers), null);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static TrustManager[] createTrustManagers(SslConfiguration config) {
        return ConscryptCompatTrustManagers.wrap(SslSocketFactories.createTrustManagerFactory(config.trustStorePath(), config.trustStoreType()).getTrustManagers());
    }

    public static TrustManager[] createTrustManagers(Map<String, PemX509Certificate> trustCertificatesByAlias) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(KeyStores.createTrustStoreFromCertificates(trustCertificatesByAlias));
            return ConscryptCompatTrustManagers.wrap(trustManagerFactory.getTrustManagers());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static TrustContext createTrustContext(SslConfiguration config) {
        TrustManager[] trustManagers = SslSocketFactories.createTrustManagers(config);
        KeyManager[] keyManagers = SslSocketFactories.createKeyManagers(config);
        SSLContext context = SslSocketFactories.createSslContext(trustManagers, keyManagers);
        return TrustContext.of(context.getSocketFactory(), SslSocketFactories.getX509TrustManager(trustManagers));
    }

    public static TrustContext createTrustContext(Map<String, PemX509Certificate> trustCertificatesByAlias) {
        TrustManager[] trustManagers = SslSocketFactories.createTrustManagers(trustCertificatesByAlias);
        SSLContext context = SslSocketFactories.createSslContext(trustManagers, new KeyManager[0]);
        return TrustContext.of(context.getSocketFactory(), SslSocketFactories.getX509TrustManager(trustManagers));
    }

    public static X509TrustManager createX509TrustManager(SslConfiguration config) {
        return SslSocketFactories.getX509TrustManager(SslSocketFactories.createTrustManagers(config));
    }

    public static X509TrustManager createX509TrustManager(Map<String, PemX509Certificate> certificatesByAlias) {
        return SslSocketFactories.getX509TrustManager(SslSocketFactories.createTrustManagers(certificatesByAlias));
    }

    public static X509TrustManager getX509TrustManager(TrustManager[] trustManagers) {
        TrustManager trustManager = trustManagers[0];
        if (trustManager instanceof X509TrustManager) {
            return (X509TrustManager)trustManager;
        }
        throw new SafeRuntimeException("First TrustManager associated with SslConfiguration was expected to be an X509TrustManager", SafeArg.of("actualType", trustManager.getClass().getSimpleName()));
    }

    public static KeyManager[] createKeyManagers(SslConfiguration config) {
        return config.keyStorePath().map(keyStorePath -> SslSocketFactories.createKeyManagerFactory(keyStorePath, config.keyStorePassword(), config.keyStoreType(), config.keyStoreKeyAlias()).getKeyManagers()).orElse(null);
    }

    private static TrustManagerFactory createTrustManagerFactory(Path trustStorePath, SslConfiguration.StoreType trustStoreType) {
        KeyStore keyStore;
        switch (trustStoreType) {
            case JKS: 
            case PKCS12: {
                keyStore = KeyStores.loadKeyStore(trustStoreType.name(), trustStorePath, Optional.empty());
                break;
            }
            case PEM: {
                keyStore = KeyStores.createTrustStoreFromCertificates(trustStorePath);
                break;
            }
            case PUPPET: {
                Path puppetCertsDir = trustStorePath.resolve("certs");
                if (!puppetCertsDir.toFile().isDirectory()) {
                    throw new IllegalStateException(String.format("Puppet certs directory did not exist at path \"%s\"", puppetCertsDir));
                }
                keyStore = KeyStores.createTrustStoreFromCertificates(puppetCertsDir);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized trust store type: " + trustStoreType);
            }
        }
        DefaultCas.getCertificates().forEach((certAlias, cert) -> {
            try {
                keyStore.setCertificateEntry((String)certAlias, (Certificate)cert);
            }
            catch (KeyStoreException e) {
                throw new SafeRuntimeException("Unable to add certificate to store", (Throwable)e, SafeArg.of("certificateAlias", certAlias));
            }
        });
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyManagerFactory createKeyManagerFactory(Path keyStorePath, Optional<String> keyStorePassword, SslConfiguration.StoreType keyStoreType, Optional<String> keyStoreKeyAlias) {
        KeyStore keyStore;
        switch (keyStoreType) {
            case JKS: 
            case PKCS12: {
                keyStore = KeyStores.loadKeyStore(keyStoreType.name(), keyStorePath, keyStorePassword);
                break;
            }
            case PEM: {
                keyStore = KeyStores.createKeyStoreFromCombinedPems(keyStorePath);
                break;
            }
            case PUPPET: {
                Path puppetKeysDir = keyStorePath.resolve("private_keys");
                Path puppetCertsDir = keyStorePath.resolve("certs");
                keyStore = KeyStores.createKeyStoreFromPemDirectories(puppetKeysDir, ".pem", puppetCertsDir, ".pem");
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized key store type: " + keyStoreType);
            }
        }
        if (keyStoreKeyAlias.isPresent()) {
            keyStore = KeyStores.newKeyStoreWithEntry(keyStore, keyStorePassword, keyStoreKeyAlias.get());
        }
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyStorePassword.map(String::toCharArray).orElse(null));
            return keyManagerFactory;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

